package com.liquidnet.service.sweet.config;

import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.annotation.PostConstruct;

@Configuration
public class WechatMpConfigure {
    private static String appidZhengzai;
    private static String secretZhengzai;
    private static String tokenZhengzai;
    private static String aeskeyZhengzai;

    private static String appidModernsky;
    private static String secretModernsky;

    @Value("${liquidnet.wechat.service.zhengzai.appid}")
    public void setAppidZhengzai(String appidZhengzai) { WechatMpConfigure.appidZhengzai = appidZhengzai; }
    @Value("${liquidnet.wechat.service.zhengzai.secret}")
    public void setSecretZhengzai(String secretZhengzai) {
        WechatMpConfigure.secretZhengzai = secretZhengzai;
    }
    @Value("${liquidnet.wechat.service.zhengzai.token}")
    public void setTokenZhengzai(String tokenZhengzai) {
        WechatMpConfigure.tokenZhengzai = tokenZhengzai;
    }
    @Value("${liquidnet.wechat.service.zhengzai.aeskey}")
    public void setAeskeyZhengzai(String aeskeyZhengzai) {
        WechatMpConfigure.aeskeyZhengzai = aeskeyZhengzai;
    }

    @Value("${liquidnet.wechat.service.modernsky.appid}")
    public void setAppidModernsky(String appidModernsky) {
        WechatMpConfigure.appidModernsky = appidModernsky;
    }
    @Value("${liquidnet.wechat.service.modernsky.secret}")
    public void setSecretModernsky(String secretModernsky) {
        WechatMpConfigure.secretModernsky = secretModernsky;
    }

    private WxMpService wxMpZhengzaiService;
    private WxMpService wxMpModernskyService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @PostConstruct
    public void init() {
        wxMpZhengzaiService = new WxMpServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMpRedisConfigImpl wxMpDefaultConfig = new WxMpRedisConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:service:zhengzai");

                wxMpDefaultConfig.setAppId(appidZhengzai);
                wxMpDefaultConfig.setSecret(secretZhengzai);
                wxMpDefaultConfig.setToken(tokenZhengzai);
                wxMpDefaultConfig.setAesKey(aeskeyZhengzai);

                this.setWxMpConfigStorage(wxMpDefaultConfig);
            }
        };
        wxMpModernskyService = new WxMpServiceImpl() {
            {
                RedisTemplateWxRedisOps redisTemplateWxRedisOps = new RedisTemplateWxRedisOps(stringRedisTemplate);
                WxMpRedisConfigImpl wxMpDefaultConfig = new WxMpRedisConfigImpl(redisTemplateWxRedisOps, "sweet:accessToken:service:modernsky");

                wxMpDefaultConfig.setAppId(appidModernsky);
                wxMpDefaultConfig.setSecret(secretModernsky);

                this.setWxMpConfigStorage(wxMpDefaultConfig);
            }
        };
    }

    public WxMpService getWxMpService(Integer pnum) {
        switch (pnum) {
            case 1:
                return wxMpZhengzaiService;
            case 2:
                return wxMpModernskyService;
        }
        return null;
    }
}
