/**
 * $Id: SerializableUtil.java 1075 2015-10-29 01:53:35Z yupengfei $
 * Copyright(C) 2014-2020 netease - easegame, All Rights Reserved.
 */
package com.liquidnet.commons.lang.util;

import java.io.*;

/**
 *
 * @author <a href="mailto:yupengfei@kowlone.com">kowlone</a>
 * @version 1.0 2015年10月29日 上午9:48:15
 */
public class SerializableUtil implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -1692288958400385478L;

	/**
	 * 序列化一个对象
	 *
	 * @param obj
	 * @return
	 */
	public static byte[] serialize(Object obj) throws Exception {
		ObjectOutputStream oos = null;
		ByteArrayOutputStream baos = null;
		baos = new ByteArrayOutputStream();
		oos = new ObjectOutputStream(baos);
		oos.writeObject(obj);
		byte[] bytes = baos.toByteArray();
		return bytes;
	}

	/**
	 * 反序列化一个对象
	 *
	 * @param bytes
	 * @return
	 */
	public static Object unserialize(byte[] bytes) throws Exception {
		ByteArrayInputStream bais = null;
		ObjectInputStream ois = null;
		bais = new ByteArrayInputStream(bytes);
		ois = new ObjectInputStream(bais);
		return ois.readObject();
	}



}
