package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressRouteVo;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressVo;
import com.liquidnet.service.kylin.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.LinkedList;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
@Slf4j
public class PerformancesExpressInfoServiceImpl {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    HttpServletRequest httpServletRequest;

    @Autowired
    private DataUtils dataUtils;

    public KylinOrderExpressVo orderRouteDetail(String orderTicketsId) {
        LinkedList<KylinOrderExpressRouteVo> routeList = dataUtils.getOrderExpressRoute(orderTicketsId);
        KylinOrderExpressVo expressInfo = dataUtils.getOrderExpressInfos(orderTicketsId);
        if (null != expressInfo) {
            expressInfo.setRouteList(routeList);
        }
        return expressInfo;
    }

    public KylinOrderExpressVo orderRefundRouteDetail(String orderTicketsId) {
        KylinOrderExpressVo expressInfo = dataUtils.getOrderRefundExpressInfo(orderTicketsId);
        if (expressInfo.getSendExpressType() == 1) {
            LinkedList<KylinOrderExpressRouteVo> routeList = dataUtils.getOrderExpressRoute(orderTicketsId);
            if (null != expressInfo) {
                expressInfo.setRouteList(routeList);
            }
        } else {
            // TODO: jxl 2021/8/27 查询物流信息
            expressInfo.setRouteList(null);
        }
        return expressInfo;
    }
}