package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "account param")
public class BankCcAccountParam {


    @ApiModelProperty(value = "请求唯一标识")
    private String uniqueRequestId;


    @ApiModelProperty(value = "Account name.", required = true)
    private String accountName;

    @ApiModelProperty(value = "Legal entity.", required = true, allowableValues = "company,individual")
    private String legalEntityType;

    @ApiModelProperty(value = "First line of address.", required = true)
    private String street;

    @ApiModelProperty(value = "City.", required = true)
    private String city;

    @ApiModelProperty(value = "Postal code.", required = true)
    private String postalCode;

    @ApiModelProperty(value = "Two-letter country code.", required = true)
    private String country;

    @ApiModelProperty(value = "State or province two-letter ISO 3166 code. Only applicable to some countries.")
    private String stateOrProvince;


}
