package com.liquidnet.service.bank.currencycloud.controller;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;
import com.liquidnet.service.bank.currencycloud.service.IBankCcBalanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-14
 */
@Api(tags = "balance")
@Slf4j
@RestController
@RequestMapping("/bank-cc-balance")
public class BankCcBalanceController {

    @Autowired
    IBankCcBalanceService bankCcBalanceService;

    @ApiOperation(value = "retrieve balance")
    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @GetMapping("/retrieve")
    public ResponseDto<BankCcBalance> retrieve(HttpServletRequest request,
                                               @RequestParam String currency,
                                               @RequestParam(required = false) String contactId) {
        log.info("retrieve balance,currency=[{}],contactId=[{}]", currency, contactId);

        try {
            BankResultDto<BankCcBalance> dto = bankCcBalanceService.retrieveBalance(currency, contactId);
            return BankResultDto.getResponseDto(dto);
        } catch (Exception e) {
            log.error("retrieve balance error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }

    }

}
