package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.TicketInventoryDto;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.liquidnet.service.kylin.dto.vo.TicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.TicketVo;
import com.mongodb.BasicDBObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class PerformanceVoTask {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private RedisUtil redisUtil;


    public void performanceVoStatus(String performanceSingleId) {

        LocalDateTime timeNow = LocalDateTime.now();
        List<String> performanceIdList = new ArrayList<>();

        if (performanceSingleId.isEmpty()) {
            List<PerformanceVo> PerformanceVoList = mongoTemplate.findAll(PerformanceVo.class);
            for (PerformanceVo performanceVoItem : PerformanceVoList) {
                performanceIdList.add(performanceVoItem.getPerformancesId());
            }
        } else {
            performanceIdList.add(performanceSingleId);
        }

        for (String performancesId : performanceIdList) {
            //场次
            List<TicketTimesVo> timesData = mongoTemplate.find(
                    Query.query(Criteria.where("performanceId").is(performancesId)),
                    TicketTimesVo.class, TicketTimesVo.class.getSimpleName()
            );
            //总循环次数
            int ticketCount = 0;
            //未开售次数
            int status9Count = 0;
            //售罄次数
            int status8Count = 0;
            //已结束次数
            int status10Count = 0;
            //演出数据
            HashMap<String, Object> mapPerformance = new HashMap<>();
            int appStatus = 6;
            for (TicketTimesVo ticketTimesVoItem : timesData) {
                //票
//                List<TicketVo> ticketVoList = ticketTimesVoItem.getTicketVoList();
                List<TicketVo> ticketVoList = mongoTemplate.find(
                        Query.query(Criteria.where("timeId").is(ticketTimesVoItem.getTimeId())),
                        TicketVo.class, TicketVo.class.getSimpleName()
                );
                ticketCount += ticketVoList.size();
                for (TicketVo ticketVoItem : ticketVoList) {
                    //时间判断
                    LocalDateTime timeStart = LocalDateTime.parse(ticketVoItem.getMemberTimeStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    LocalDateTime timeEnd = LocalDateTime.parse(ticketVoItem.getTimeEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    int status = 0;
                    if (timeStart.isAfter(timeNow)) {
                        //未开始
                        status = 9;
                        status9Count += 1;
                    } else if (timeEnd.isBefore(timeNow)) {
                        //结束
                        status = 10;
                        status10Count += 1;
                    } else {
                        //库存判断
                        TicketInventoryDto ticketInventoryRedis = (TicketInventoryDto) redisUtil.hget(KylinRedisConst.PERFORMANCES_INVENTORY, ticketVoItem.getTicketsId());
                        if (ticketInventoryRedis.getSurplusGeneral() > 0) {
                            status = 6;
                        } else {
                            status = 8;
                            status8Count += 1;
                        }
                    }
                    //修改票状态
                    HashMap<String, Object> mapTicket = new HashMap<>();
                    mapTicket.put("status", status);
                    BasicDBObject objectTicket = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapTicket));
                    mongoTemplate.getCollection(TicketVo.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("ticketsId").is(ticketVoItem.getTicketsId())).getQueryObject(),
                            objectTicket
                    );
//                    //修改场次 内 票数据
//                    mongoTemplate.getCollection(TicketTimesVo.class.getSimpleName()).updateOne(
//                            Query.query(Criteria.where("ticketVoList.ticketsId").is(ticketVoItem.getTicketsId())).getQueryObject(),
//                            objectTicket
//                    );
                    //演出状态
                    if (status == 6) {//单一票 可购买 则为可购买
                        appStatus = 6;
                    } else if (ticketCount == status8Count) {//全票售罄为售罄
                        appStatus = 8;
                    } else if (ticketCount == status9Count) {//全票未开始 为未开始
                        appStatus = 9;
                    } else if (ticketCount == status10Count) {//全票结束 为结束
                        appStatus = 10;
                    }
                }
            }
            //修改演出状态
            mapPerformance.put("appStatus", appStatus);
            BasicDBObject objectPerformance = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapPerformance));
            mongoTemplate.getCollection(PerformanceVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                    objectPerformance
            );
        }
    }

}
