package com.liquidnet.service.sweet.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.liquidnet.service.base.ResponseDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Objects;

/**
 * <p>
 * 小程序登陆 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-27
 */
@Service
public class SweetLoginServiceImpl {

    @Value("${liquidnet.wechat.applet.strawberry.appid}")
    private String strawberryAppid;
    @Value("${liquidnet.wechat.applet.strawberry.secret}")
    private String strawberrySecret;

    @Value("${liquidnet.wechat.applet.five.appid}")
    private String fiveAppid;
    @Value("${liquidnet.wechat.applet.five.secret}")
    private String fiveSecret;

    @Value("${liquidnet.wechat.applet.mdsk.appid}")
    private String mdskAppid;
    @Value("${liquidnet.wechat.applet.mdsk.secret}")
    private String mdskSecret;

    public ResponseDto userInfo(String code, String encryptedData, String iv, Integer type) {
        try {
            String appId = "";
            String appSecret = "";
            switch (type) {
                case 1:
                    appId = strawberryAppid;
                    appSecret = strawberrySecret;
                    break;
                case 2:
                    appId = fiveAppid;
                    appSecret = fiveSecret;
                    break;
                case 3:
                    appId = mdskAppid;
                    appSecret = mdskSecret;
                    break;
            }
            WxMaConfig wxMaConfig = wxMaConfig(appId, appSecret);
            WxMaService wxMaService = wxMaService(wxMaConfig);
            WxMaJscode2SessionResult sessionInfo = wxMaService.getUserService().getSessionInfo(code);
            if (null == sessionInfo) {
                return ResponseDto.failure("login handler error");
            }

            // 解密用户信息
            WxMaUserInfo wxUserInfo = wxMaService.getUserService().getUserInfo(sessionInfo.getSessionKey(),
                    encryptedData, iv);
            if (null == wxUserInfo) {
                return ResponseDto.failure("wxUser not exist");
            }

            // 解密手机号码信息
            WxMaPhoneNumberInfo wxMaPhoneNumberInfo = wxMaService.getUserService().getPhoneNoInfo(sessionInfo.getSessionKey(),
                    encryptedData, iv);
            if (Objects.isNull(wxMaPhoneNumberInfo) || StringUtils.isBlank(wxMaPhoneNumberInfo.getPhoneNumber())) {
                return ResponseDto.failure("解密手机号码信息错误");
            }

            String unionId = sessionInfo.getUnionid();
            String openId = sessionInfo.getOpenid();

            HashMap userInfo = new HashMap();
            userInfo.put("unionId", unionId);
            userInfo.put("openId", openId);

            return ResponseDto.success(userInfo);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    private WxMaConfig wxMaConfig(String appId, String appSecret) {
        WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
        config.setAppid(appId);
        config.setSecret(appSecret);
        config.setMsgDataFormat("JSON");
        return config;
    }

    private WxMaService wxMaService(WxMaConfig maConfig) {
        WxMaService service = new WxMaServiceImpl();
        service.setWxMaConfig(maConfig);
        return service;
    }

}
