package com.liquidnet.service.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.IKylinOrderRefundsService;
import com.liquidnet.service.kylin.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 订单退款表 服务实现类 处理逻辑判断
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class OrderRefundOvertimeServiceImpl implements IKylinOrderRefundsService {
    @Autowired
    private KylinRefundsStatusServiceImpl kylinRefundsStatusServiceImpl;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private DataUtils dataUtils;

    public Boolean refundApply(String orderTicketsId) {
        KylinOrderTicketVo orderInfo = dataUtils.getOrderTicketVo(orderTicketsId);
        // 快递费 未进行判断
        Double RefundPriceExpress = orderInfo.getPriceExpress().doubleValue();
        double priceActual = orderInfo.getPriceActual().doubleValue();
        double priceExpress = orderInfo.getPriceExpress().doubleValue();

        // 查询订单入场人
        List<KylinOrderTicketEntitiesVo> entitiesList = orderInfo.getEntitiesVoList();
        if (!CollectionUtil.isEmpty(entitiesList)) {
            int allEntitiesCount = entitiesList.size();// 总入场人数量 排出未付款的 用来计算单入场人的价格
            double onePrice = (priceActual - priceExpress) / allEntitiesCount;//单价
            for (KylinOrderTicketEntitiesVo entities : entitiesList) {
                entities.setCanRefundedPrice(BigDecimal.valueOf(onePrice));
            }
        }

        List<String> ticketEntityIds = entitiesList.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getOrderTicketEntitiesId()).collect(Collectors.toList());
        List<Double> entitiesPrice = entitiesList.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getCanRefundedPrice().doubleValue()).collect(Collectors.toList());

        boolean res = kylinRefundsStatusServiceImpl.orderTicketRefunding(
                orderInfo, orderTicketsId,
                RefundPriceExpress,
                ticketEntityIds, entitiesPrice
        );
        if (res) {
            // 超时直接退还库存
            for (KylinOrderTicketEntitiesVo entitiesInfo : entitiesList) {
                // 因固定状态为未支付 所以无需判断 entitiesInfo.getIsPayment() == KylinTableStatusConst.ENTITIES_IS_PAYMENT3
                dataUtils.changeSurplusGeneral(entitiesInfo.getTicketId(), 1);
                dataUtils.changeBuyInfo(orderInfo.getUserId(), entitiesInfo.getEnterIdCode(), orderInfo.getPerformanceId(), entitiesInfo.getTicketId(), -1);
            }
            return true;
        } else {
            return false;
        }
    }
}
