package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinCommonService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.GoblinStoreSearchDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "商铺公共方法")
@Controller
@RequestMapping("goblin/common")
public class GoblinCommonController extends BaseController {

    @Autowired
    IGoblinCommonService goblinCommonService;

    @Log(title = "获取店铺列表", businessType = BusinessType.LIST)
    @GetMapping("store")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "name", value = "店铺名称[模糊]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "List<String>", name = "status", value = "状态数组]"),
    })
    @ResponseBody
    public ResponseDto<List<GoblinStoreSearchDto>> storeSearch(String name, List<String> status) {
        return ResponseDto.success(goblinCommonService.storeSearch(name, status));
    }

    @Log(title = "商品搜索", businessType = BusinessType.LIST)
    @GetMapping("goods")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "title", value = "商品名称[模糊]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "type", value = "商品类型[0-常规|1-数字藏品]"),
    })
    @ResponseBody
    public AjaxResult goodsSearch(String title, Integer type) {
        return AjaxResult.success(goblinCommonService.goodsSearch(title, type));
    }

    @Log(title = "商品搜索", businessType = BusinessType.LIST)
    @GetMapping("sku")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "title", value = "商品名称[模糊]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "type", value = "商品类型[0-常规|1-数字藏品]"),
    })
    @ResponseBody
    public AjaxResult skuSearch(String title, Integer type) {
        return AjaxResult.success(goblinCommonService.skuSearch(title, type));
    }

    /** ------------------------------------------------------------------------ **/
}
