package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 订单退单退款表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinBackOrderSkuVo implements Serializable,Cloneable {

    @ApiModelProperty(value = "orderSkuId")
    private String orderSkuId;
    @ApiModelProperty(value = "spuId")
    private String spuId;
    @ApiModelProperty(value = "spu名称")
    private String spuName;
    @ApiModelProperty(value = "spu图")
    private String spuPic;
    @ApiModelProperty(value = "SkuId")
    private String skuId;
    @ApiModelProperty(value = "Sku图")
    private String skuPic;
    @ApiModelProperty(value = "Sku名称")
    private String skuName;
    @ApiModelProperty(value = "Sku款式")
    private String skuSpecs;
    @ApiModelProperty(value = "退款金额")
    private BigDecimal refundPrice;


    @ApiModelProperty(value = "创建时间")
    private String createdAt;

    private static final GoblinBackOrderSkuVo obj = new GoblinBackOrderSkuVo();

    public static GoblinBackOrderSkuVo getNew() {
        try {
            return (GoblinBackOrderSkuVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinBackOrderSkuVo();
    }
}
