package com.liquidnet.service.sweet.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

@Configuration
public class WechatMaConfigure {
    private static String appletAppidZhengzai;
    private static String appletSecretZhengzai;

    private static String appletAppidStrawberry;
    private static String appletSecretStrawberry;

    private static String appletAppidFive;
    private static String appletSecretFive;

    private static String appletAppidMdsk;
    private static String appletSecretMdsk;

    @Value("${liquidnet.wechat.applet.strawberry.appid}")
    public void setAppletAppidZhengzai(String appletAppidZhengzai) {
        WechatMaConfigure.appletAppidZhengzai = appletAppidZhengzai;
    }

    @Value("${liquidnet.wechat.applet.strawberry.secret}")
    public void setAppletSecretZhengzai(String appletSecretZhengzai) {
        WechatMaConfigure.appletSecretZhengzai = appletSecretZhengzai;
    }

    @Value("${liquidnet.wechat.applet.strawberry.appid}")
    public void setAppletAppidStrawberry(String appletAppidStrawberry) {
        WechatMaConfigure.appletAppidStrawberry = appletAppidStrawberry;
    }

    @Value("${liquidnet.wechat.applet.strawberry.secret}")
    public void setAppletSecretStrawberry(String appletSecretStrawberry) {
        WechatMaConfigure.appletSecretStrawberry = appletSecretStrawberry;
    }

    @Value("${liquidnet.wechat.applet.five.appid}")
    public void setAppletAppidFive(String appletAppidFive) {
        WechatMaConfigure.appletAppidFive = appletAppidFive;
    }

    @Value("${liquidnet.wechat.applet.five.secret}")
    public void setAppletSecretFive(String appletSecretFive) {
        WechatMaConfigure.appletSecretFive = appletSecretFive;
    }

    @Value("${liquidnet.wechat.applet.mdsk.appid}")
    public void setAppletAppidMdsk(String appletAppidMdsk) {
        WechatMaConfigure.appletAppidMdsk = appletAppidMdsk;
    }

    @Value("${liquidnet.wechat.applet.mdsk.secret}")
    public void setAppletSecretMdsk(String appletSecretMdsk) {
        WechatMaConfigure.appletSecretMdsk = appletSecretMdsk;
    }

    private WxMaService wxMaAppletZhengzaiService;
    private WxMaService wxMaAppletStrawberryService;
    private WxMaService wxMaAppletFiveService;
    private WxMaService wxMaAppletMdskService;

    @PostConstruct
    public void init() {
        wxMaAppletZhengzaiService = new WxMaServiceImpl() {
            {
                WxMaDefaultConfigImpl wxMaDefaultConfig = new WxMaDefaultConfigImpl();
                wxMaDefaultConfig.setAppid(appletAppidZhengzai);
                wxMaDefaultConfig.setSecret(appletSecretZhengzai);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletStrawberryService = new WxMaServiceImpl() {
            {
                WxMaDefaultConfigImpl wxMaDefaultConfig = new WxMaDefaultConfigImpl();
                wxMaDefaultConfig.setAppid(appletAppidStrawberry);
                wxMaDefaultConfig.setSecret(appletSecretStrawberry);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletFiveService = new WxMaServiceImpl() {
            {
                WxMaDefaultConfigImpl wxMaDefaultConfig = new WxMaDefaultConfigImpl();
                wxMaDefaultConfig.setAppid(appletAppidFive);
                wxMaDefaultConfig.setSecret(appletSecretFive);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
        wxMaAppletMdskService = new WxMaServiceImpl() {
            {
                WxMaDefaultConfigImpl wxMaDefaultConfig = new WxMaDefaultConfigImpl();
                wxMaDefaultConfig.setAppid(appletAppidMdsk);
                wxMaDefaultConfig.setSecret(appletSecretMdsk);
                wxMaDefaultConfig.setMsgDataFormat("JSON");

                this.setWxMaConfig(wxMaDefaultConfig);
            }
        };
    }

    public WxMaService getWxMaService(Integer anum) {
        switch (anum) {
            case 4:
                return wxMaAppletZhengzaiService;
            case 1:
                return wxMaAppletStrawberryService;
            case 2:
                return wxMaAppletFiveService;
            case 3:
                return wxMaAppletMdskService;
        }
        return null;
    }
}
