package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.service.IFeishuBotService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class FeishuBotServiceImpl implements IFeishuBotService {

    @Value("${liquidnet.feishu.bWebhook}")
    private String bWebhook;

    @Override
    public void sendTextMessage(String text) {
        HashMap<String, Object> textMap = new HashMap<>();
        textMap.put("text", text);

        Map<String, Object> bodyMap = new HashMap<>();
        bodyMap.put("msg_type", "text");
        bodyMap.put("content", textMap);
        try {
            HttpUtil.postJson(bWebhook, JsonUtils.toJson(bodyMap));
        }catch (Exception e){
            log.error("error.", e);
        }
    }
}
