package com.liquidnet.service.goblin.dto.manage;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@ApiModel(value = "GoblinGoodsAnticipateParam", description = "预约")
@Data
public class GoblinGoodsAnticipateAddParam {

    /**
     * 预约规则
     */
    @ApiModelProperty(value = "预约规则")
    @NotBlank(message = "预约规则")
    private String rule;


    @ApiModelProperty("sku信息")
    private List<GoblinGoodsAnticipateValueAddParam> list;


}
