package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "AdamMemberParam", description = "添加会员入参")
@Data
public class AdamMemberParam implements Serializable {
    private static final long serialVersionUID = -7411934614249221021L;
    @ApiModelProperty(position = 0, required = false, value = "会员ID[50]")
    private String memberId;
    @ApiModelProperty(position = 1, required = true, value = "会员名称[50]", example = "摩登天空会员卡")
    private String name;
    @ApiModelProperty(position = 2, required = true, value = "会员标题[50]", example = "摩登天空会员卡")
    private String title;
    @ApiModelProperty(position = 3, required = true, value = "会员副标题[50]", example = "摩登天空会员卡副标题")
    private String subTitle;
    @ApiModelProperty(position = 4, required = true, value = "icon图标[200]", example = "https://img.zhengzai.tv/files/2020/08/28/5f490418d30b4.png")
    private String icon;
    @ApiModelProperty(position = 5, required = true, value = "会员头像[200]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    private String avatar;
    @ApiModelProperty(position = 6, required = true, value = "权益详情[200]", example = "加入摩登天空会员您可享受到.....")
    private String interestsDetail;
    @ApiModelProperty(position = 7, required = true, value = "注意事项[200]", example = "摩登天空会员需注意以下事项.....")
    private String notes;
    @ApiModelProperty(position = 8, required = true, value = "是否展示须知[[0-否,1-是]]", allowableValues = "0,1")
    private Integer isNotice;
    @ApiModelProperty(position = 9, required = true, value = "会员须知内容[200]", example = "会员须知细则1.xxxx\n2.xxxx")
    private String noticeInfo;
    @ApiModelProperty(position = 10, required = true, value = "会员须知标题[200]", example = "摩登天空会员须知")
    private String noticeTitle;
    @ApiModelProperty(position = 11, required = true, value = "是否需要答题[0-否,1-是]", allowableValues = "0,1")
    private Integer needQuestion;
    @ApiModelProperty(position = 12, required = true, value = "是否展示协议[0-否,1-是]", allowableValues = "0,1")
    private Integer displayAgreement;
    @ApiModelProperty(position = 13, required = true, value = "状态[1-NORMAL,2-INVALID]")
    private Integer state;
    @ApiModelProperty(position = 14, required = true, value = "限购数量，0不限购[200]", example = "0")
    private Integer limitation;
    @ApiModelProperty(position = 15, required = true, value = "会员卡价格ID", example = "[63666042953703424]")
    private List<String> memberPriceList;
}
