package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 快递时间线表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ExpressTimelines implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 快递
     */
    private Integer expressId;

    /**
     * 快递消息
     */
    private String context;

    /**
     * 时间，原始格式
     */
    private String time;

    /**
     * 格式化后时间
     */
    private LocalDateTime ftime;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
