package com.liquidnet.service.base;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

@Data
public class MdbMessage implements Serializable, Cloneable {
    private static final long serialVersionUID = 4814549190217810630L;
    /**
     * Mongo集合名
     */
    private String collect;
    /**
     * Mongo集合中的字段属性名称
     */
    private String column;
    /**
     * Mongo集合中的字段属性值
     */
    private String bizId;
    /**
     * Redis缓存中的Key前缀
     */
    private String prefix;
    /**
     * 操作类型[1-insert|2-update]
     */
    private int opType;

    private static final MdbMessage obj = new MdbMessage();

    public static MdbMessage getNew() {
        return obj.clone();
    }

    @Override
    public MdbMessage clone() {
        try {
            return (MdbMessage) super.clone();
        } catch (CloneNotSupportedException e) {
            return new MdbMessage();
        }
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
