package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinPerformancesAdminServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRoadShowsAdminServiceImpl;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import com.liquidnet.service.kylin.dao.RoadShowAdminListDao;
import com.liquidnet.service.kylin.dto.param.CreateRoadShowParam;
import com.liquidnet.service.kylin.dto.vo.admin.KylinRoadShowAdminVo;
import com.liquidnet.service.kylin.dto.vo.partner.KylinPerformanceMisVo;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import com.liquidnet.service.kylin.service.admin.IKylinRoadShowsAdminService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 演出Controller
 *
 * @author anjiabin
 * @date 2021-05-24
 */
@Controller
@RequestMapping("/kylin/performances/roadShow")
public class KylinRoadShowController extends BaseController {
    private String prefix = "zhengzai/kylin/performances/roadShow";

    @Autowired
    private IKylinRoadShowsAdminService kylinRoadShowsAdminService;
    @Autowired
    private IKylinPerformancesAdminService kylinPerformancesService;

    @RequiresPermissions("kylin:performances:roadShow")
    @GetMapping()
    public String roadShow() {
        return prefix + "/roadShow";
    }

    @RequiresPermissions("kylin:performances:roadShow:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo listRoadShow(@RequestParam(value = "title", required = false) String title,
                                      @RequestParam(value = "pageNum") int page,
                                      @RequestParam(value = "pageSize") int size) {
        startPage();
        PageInfo<RoadShowAdminListDao> result = kylinRoadShowsAdminService.listRoadShow(title, page, size);
        return getDataTable(result.getList());
    }

    /**
     * 新增巡演
     */
    @GetMapping("/add")
    public String add() {
        return prefix + "/add";
    }

    @RequiresPermissions("kylin:performances:roadShow:add")
    @Log(title = "巡演", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    @ResponseBody
    public AjaxResult createRoadShow(CreateRoadShowParam createRoadShowParam) {
        return toAjax(!kylinRoadShowsAdminService.createRoadShow(createRoadShowParam).equals(""));
    }

    @RequiresPermissions("kylin:performances:roadShow:details")
    @GetMapping(value = "/details/{roadShowId}")
    public String detailsRoadShow(@PathVariable("roadShowId") String roadShowId, ModelMap mmap) {
        KylinRoadShowAdminVo result = kylinRoadShowsAdminService.detailsRoadShow(roadShowId);
        mmap.put("kylinRoadShowAdminVo", result);
        return prefix + "/edit";
    }

    @RequiresPermissions("kylin:performances:roadShow:edit")
    @Log(title = "巡演", businessType = BusinessType.UPDATE)
    @PostMapping("/edit")
    @ResponseBody
    public AjaxResult updateRoadShow(CreateRoadShowParam createRoadShowParam) {
        return toAjax(kylinRoadShowsAdminService.updateRoadShow(createRoadShowParam));
    }


    /**
     * 巡演详情
     */
    @GetMapping("/detailsList/{roadShowId}")
    public String addPerformance(@PathVariable("roadShowId") String roadShowId, ModelMap mmap) {
        mmap.put("roadShowId", roadShowId);
        return prefix + "/details";
    }

    @RequiresPermissions("kylin:performances:roadShow:addPerformance")
    @GetMapping(value = "/performance/{roadShowId}")
    @ResponseBody
    public TableDataInfo listByRoadShowId(@PathVariable("roadShowId") String roadShowId) {
        List<PerformanceTitleDao> result = kylinPerformancesService.getListByRoadShowId(roadShowId);
        return getDataTable(result);
    }


    @RequiresPermissions("kylin:performances:roadShow:change:performance")
    @PostMapping(value = "/roadShow/relation")
    @ResponseBody
    public AjaxResult changeRoadShowId(@RequestParam(value = "ids") String performancesId,@RequestParam(value = "roadShowId",required = false) String roadShowId) {
        boolean result = kylinPerformancesService.changeRoadShowId(performancesId,roadShowId);
        return toAjax(result);
    }

    /**
     * 新增巡演演出
     */
    @GetMapping("/addPerformances/{roadShowId}")
    public String addPerformances(@PathVariable("roadShowId") String roadShowId, ModelMap mmap) {
        mmap.put("roadShowId", roadShowId);
        return prefix + "/addPerformances";
    }

    @RequiresPermissions("kylin:performances:roadShow:change:performance")
    @GetMapping(value = "/performance/status")
    @ResponseBody
    public AjaxResult listByStatus(@RequestParam(value = "status") String status,@RequestParam(value = "title",required = false) String title) {
        List<PerformanceTitleDao> result = kylinPerformancesService.getListByStatus(status,title);
        AjaxResult ajax = new AjaxResult();
        ajax.put("value", result);
        return ajax;
    }
}

