package com.liquidnet.service.adam.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.adam.entity.AdamEnters;
import com.liquidnet.service.adam.mapper.AdamEntersMapper;
import com.liquidnet.service.adam.service.IAdamEntersService;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 入场人 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-28
 */
@Slf4j
@Service
public class AdamEntersServiceImpl extends ServiceImpl<AdamEntersMapper, AdamEnters> implements IAdamEntersService {
    @Autowired
    AdamEntersMapper adamEntersMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public List<AdamEnters> list(String uid) {
        List<AdamEnters> infoList = null;

        Map<Object, Object> map = redisUtil.hmget(AdamRedisConst.INFO_ENTERS.concat(uid));

        if (CollectionUtils.isEmpty(map)) {
            infoList = mongoTemplate.find(Query.query(Criteria.where("uid").is(uid)), AdamEnters.class, AdamEnters.class.getSimpleName());
        } else {
            for (Object o : map.values()) {
                infoList.add((AdamEnters) o);
            }
        }

        return infoList;
    }

    @Override
    public void add(AdamEnters info) {
        mongoTemplate.insert(Collections.singletonList(info), AdamEnters.class.getSimpleName());

        // TODO: 2021/4/28 放入MQ


        // TODO: 2021/4/28 同步REDIS
        redisUtil.hset(AdamRedisConst.INFO_ENTERS.concat(info.getUid()), info.getEntersId(), info);
    }

    @Override
    public AdamEnters query(String uid, String entersId) {
        AdamEnters info = null;

        // TODO: 2021/4/28 REDIS:QUERY
        info = (AdamEnters) redisUtil.hget(AdamRedisConst.INFO_ENTERS.concat(uid), entersId);

        if (null == info) {
            info = mongoTemplate.findOne(Query.query(Criteria.where("entersId").is(entersId)), AdamEnters.class, AdamEnters.class.getSimpleName());
        }

        return info;
    }

    @Override
    public void edit(AdamEnters info) {
        BasicDBObject object = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(info)));
        mongoTemplate.getCollection(AdamEnters.class.getSimpleName())
                .updateOne(Query.query(Criteria.where("entersId").is(info.getEntersId())).getQueryObject(), object);

        // TODO: 2021/4/28 放入MQ


        // TODO: 2021/4/28 同步REDIS
        redisUtil.hset(AdamRedisConst.INFO_ENTERS.concat(info.getUid()), info.getEntersId(), info);
    }
}
