package com.liquidnet.service.sweet.handler;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.third.shumei.util.ShumeiUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.sweet.config.WechatMaConfigure;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.WechatUsersRedisUtils;
import com.liquidnet.service.sweet.vo.SweetMaoDengVo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutTextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Slf4j
public class MaoDengImageHandler implements WxMpMessageHandler {

    @Autowired
    private WechatUsersRedisUtils redisUtils;
    @Autowired
    private ShumeiUtil shumeiUtil;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    WechatMaConfigure maConfigure;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> map, WxMpService wxMpService, WxSessionManager wxSessionManager) throws WxErrorException {
        String fromUser = wxMessage.getFromUser();//用户id
        String picUrl = wxMessage.getPicUrl();//图片url
        String maoId = IDGenerator.nextSnowId();
        //图片非法判断
        //此处判断不需要用户登录，所以使用时间代替
        String currentUid = DateUtil.now().getTime()+"";
        if (!shumeiUtil.checkImage(currentUid, picUrl)) {
            //图片非法 提示，发送文本消息
            WxMpXmlOutTextMessage build = WxMpXmlOutMessage.TEXT().content("无法识别，你家猫猫还有别的图吗？")
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
            return build;
        }
        SweetMaoDengVo sweetMaoDengVo = SweetMaoDengVo.getNew();
        sweetMaoDengVo.setUserId(fromUser);
        sweetMaoDengVo.setPicUrl(picUrl);
        String i = redisUtils.getSweetMaoDengOpen(fromUser);
        if (StringUtil.isNotEmpty(i)){
            //活动已开启  持久化  redis
            SweetMaoDengVo sweetMaoDeng = redisUtils.getSweetMaoDengTransfer(fromUser);
            String textMsg =null;
            if (sweetMaoDeng != null){
                textMsg =sweetMaoDeng.getTextMsg();
                sweetMaoDengVo.setTextMsg(textMsg);
            }

            redisUtils.setSweetMaoDeng(sweetMaoDengVo);

            WxMpXmlOutTextMessage build = WxMpXmlOutMessage.TEXT().content("你好，"+textMsg+"   点击下方小程序卡片\n" +
                    "查看你的猫咪隐藏音乐技能。\n" +
                    "（小程序卡片，点击进入活动）\n")
                    .fromUser(wxMessage.getToUser()).toUser(wxMessage.getFromUser())
                    .build();
            // 发送活动小程序卡片
            WxMpKefuMessage message = WxMpKefuMessage.MINIPROGRAMPAGE()
                    .appId(maConfigure.getWxMaAppid(4))
                    .pagePath("/pages/index?nickname=".concat(textMsg))
                    .thumbMediaId("ov08q51In7bXX6tXv7FewxFNN0G78n-pPRsbi3LZbPE")
                    .title("在猫登天空，每一只猫咪都有自己的隐藏音乐技能！")
                    .toUser(wxMessage.getFromUser())
                    .build();
            wxMpService.getKefuService().sendKefuMessage(message);

            return build;
        }
       return null;
    }
}
