package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.adam.entity.AdamMemberOrderExt;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberOrderExtVo", description = "用户会员订单扩展信息")
@Data
public class AdamMemberOrderExtVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -1718738306110269600L;
    @ApiModelProperty(position = 1, value = "订单号")
    private String orderNo;
    @ApiModelProperty(position = 2, value = "快递状态")
    private Integer expressStatus;
    @ApiModelProperty(position = 3, value = "收件人")
    private String expressReceiver;
    @ApiModelProperty(position = 4, value = "收件人电话")
    private String expressPhone;
    @ApiModelProperty(position = 5, value = "收件人地址")
    private String expressAddress;

    private static final AdamMemberOrderExtVo obj = new AdamMemberOrderExtVo();

    public static AdamMemberOrderExtVo getNew() {
        try {
            return (AdamMemberOrderExtVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderExtVo();
        }
    }

    public AdamMemberOrderExtVo copy(AdamMemberOrderExt source) {
        if (null == source) return this;
        this.setOrderNo(source.getOrderNo());
        this.setExpressStatus(source.getExpressStatus());
        this.setExpressReceiver(source.getExpressReceiver());
        this.setExpressPhone(source.getExpressPhone());
        this.setExpressAddress(source.getExpressAddress());
        return this;
    }
}
