package com.liquidnet.service.goblin.param.dougong;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
public class DougongRequestParam {

    // 请求日期
    @JsonProperty("req_date")
    private String reqDate;

    // 请求流水号
    @JsonProperty("req_seq_id")
    private String reqSeqId;

    // 商户号
    @JsonProperty("huifu_id")
    private String huifuId;

    // 商品描述
    @JsonProperty("goods_desc")
    private String goodsDesc;

    //交易类型
    //T_JSAPI: 微信公众号
    //T_MINIAPP: 微信小程序
    //A_JSAPI: 支付宝JS
    //A_NATIVE: 支付宝正扫
    //U_NATIVE: 银联正扫
    //U_JSAPI: 银联JS
    //D_NATIVE: 数字人民币正扫
    //T_H5：微信直连H5支付
    //T_APP：微信APP支付
    //T_NATIVE：微信正扫
    @JsonProperty("trade_type")
    private String tradeType;

    // 交易金额
    @JsonProperty("trans_amt")
    private String transAmt;

    // 交易有效期
    @JsonProperty("time_expire")
    private String timeExpire;

    // 微信参数集合
    @JsonProperty("wx_data")
    private String wxData;

    // 是否延迟交易
    @JsonProperty("delay_acct_flag")
    private String delayAcctFlag = "N";

    // 异步通知地址
    @JsonProperty("notify_url")
    private String notifyUrl;

    @Data
    public static class WxData {
        //子商户应用ID
        @JsonProperty("sub_appid")
        private String subAppid;

        // 子商户用户标识
        @JsonProperty("sub_openid")
        private String subOpenid;

        //商品描述
        @JsonProperty("body")
        private String body;

        // 商品详情
        @JsonProperty("detail")
        private WxDataDetail detail;
    }

    @Data
    public static class WxDataDetail {
        @JsonProperty("cost_price")
        private String costPrice;

        @JsonProperty("goods_detail")
        private List<WxDataGoodsDetail> goodsDetail;
    }


    @Data
    public static class WxDataGoodsDetail {

        // 商品编码
        @JsonProperty("goods_id")
        private String goodsId;

        // 	商品名称
        @JsonProperty("goods_name")
        private String goodsName;

        // 商品单价(元)
        @JsonProperty("price")
        private String price;

        // 商品数量
        @JsonProperty("quantity")
        private Integer quantity;
    }
}
