package com.liquidnet.client.admin.zhengzai.smile.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.smile.entity.dto.VolunteersExportDto;
import lombok.Data;

import java.io.Serializable;

@Data
public class VolunteersExportVo implements Serializable, Cloneable{
    @Excel(name = "用户姓名", cellType = Excel.ColumnType.STRING)
    private String name;
    @Excel(name = "证件号", cellType = Excel.ColumnType.STRING)
    private String idCard;
    @Excel(name = "性别", cellType = Excel.ColumnType.STRING)
    private String sex;
    @Excel(name = "审核状态", cellType = Excel.ColumnType.STRING)
    private String status;
    @Excel(name = "学校", cellType = Excel.ColumnType.STRING)
    private String school;
//    @Excel(name = "学校地址", cellType = Excel.ColumnType.STRING)
//    private String schoolAddress;
    @Excel(name = "手机号", cellType = Excel.ColumnType.STRING)
    private String phone;
    @Excel(name = "项目名称", cellType = Excel.ColumnType.STRING)
    private String projectName;
    @Excel(name = "申请时间", cellType = Excel.ColumnType.STRING)
    private String createdAt;
//    @Excel(name = "特长", cellType = Excel.ColumnType.STRING)
//    private String specialty;
//    @Excel(name = "专长", cellType = Excel.ColumnType.STRING)
//    private String specialty2;
//    @Excel(name = "申请组1名称", cellType = Excel.ColumnType.STRING)
//    private String team1;
//    @Excel(name = "申请组2名称", cellType = Excel.ColumnType.STRING)
//    private String team2;
//    @Excel(name = "申请组3名称", cellType = Excel.ColumnType.STRING)
//    private String team3;
//    @Excel(name = "自我介绍", cellType = Excel.ColumnType.STRING)
//    private String introduce;

    private static final VolunteersExportVo obj = new VolunteersExportVo();

    public static VolunteersExportVo getNew() {
        try {
            return (VolunteersExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new VolunteersExportVo();
    }

    public VolunteersExportVo copy(VolunteersExportDto source) {
        this.setName(source.getName());
        this.setIdCard(source.getIdCard());
        this.setSex(source.getSex());
        this.setStatus(source.getStatus());
        this.setSchool(source.getSchool());
//        this.setSchoolAddress(source.getSchoolAddress());
        this.setPhone(source.getPhone());
        this.setProjectName(source.getProjectName());
        this.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getCreatedAt()));
//        this.setSpecialty(source.getSpecialty());
//        this.setSpecialty2(source.getSpecialty2());
//        this.setTeam1(source.getTeam1()==null?"":source.getTeam1());
//        this.setTeam2(source.getTeam2()==null?"":source.getTeam2());
//        this.setTeam3(source.getTeam3()==null?"":source.getTeam3());
//        this.setIntroduce(source.getIntroduce());
        return this;
    }
}
