package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * doudou预约签名CD记录表
 * </p>
 *
 * @author jiangxiulong
 * @since 2025-06-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetDoudou implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * doudou_id
     */
    private String doudouId;

    /**
     * user_id
     */
    private String userId;

    /**
     * 观演人姓名
     */
    private String username;

    /**
     * 观演人手机号
     */
    private String phone;

    /**
     * 购买平台
     */
    private String platform;

    /**
     * 购买订单号
     */
    private String orderCode;

    /**
     * 想给doudou说的话
     */
    private String mark;

    /**
     * 状态 1已登记 2未中签 3已中签 4已核销
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetDoudou obj = new SweetDoudou();

    public static SweetDoudou getNew() {
        try {
            return (SweetDoudou) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetDoudou();
        }
    }


}
