package com.liquidnet.service.goblin.service.impl;

import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.config.MerConfig;
import com.huifu.bspay.sdk.opps.core.net.BasePayRequest;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.param.dougong.DougongRequestParam;
import com.liquidnet.service.goblin.service.IGoblinDougongPayService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

@Slf4j
@Service
public class GoblinDougongPayServiceImpl implements IGoblinDougongPayService {

    // 汇付分配的产品号
    public static final String DEMO_PRODUCT_ID = "YYZY";

    // 汇付分配的系统号
    public static final String DEMO_SYS_ID = "6666000108840829";

    // 服务商私钥，用于调用接口时进行签名
    public static final String DEMO_RSA_PRIVATE_KEY = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDFOYOjLTndQiYAiFQf4ZZ6UA1T5fg2PH16XboAORgLBz/SjeiIMmIdExP1NFDH6SNqcQk6ginqk+gW0CBojEE5Loj3ROqtBRnBehVavO89xnvezsj1NZDqw416GYPCU0n6198A73c3Kn0OWoiivF5BJDra88z/zcApNzAeiVw6loZEEvzNRpfuKzs6uH6NeFQnY2wtePQwTAW5d89gUyewJSzwPPVU8r/hiPVKSB0AEkGT85UOBzaEKyAEqPfLAS/uY49Qdq+/j6lszNpjWcb6vkIeoHD3wmZdoHR7uLc+VxSk7kvJyLUv6SBtH3/jTy4ghFLQWJHagLB2QCPy9ompAgMBAAECggEAcG4JDMyLYAaFg2g0DLic/70C3AENLl3tagRkNBxYCHFpgK5FEN8n70sg5XedVVkiR1uI10G8g20tsVOUJgVOaTqN+effoCJ4PENMSR3LhHvRwYJALQkMQ8iWrjQ9WFoComzNQ8s/OsON5tDVc2/Oi3QL2SWCh5DTKqu7Uq0bVonYUX2IT8x7zWbE+tgphjI76JRDp4gkjh5ebebNBhqsOjYelNNWF3g7rVAr4zB2TMRM6N/66z/qLRk+mQQEhShojS2c2pyAtNC+7C6VZiX+XxH4ArSbf6AQyaMmPj4d3rMAYG916WNfb9GkqFyZhRNbMwRsAIfErS46PDKpKhInwQKBgQDnu4vV2U7Sqc/ab3hXh8H6d1HvxvTb7634XNyT/qtJ4nMT9CCxZE88iesqJyXNxzEElpLJRlwNPgDaJfs8qEjJ9zF6N/7ip9VPxITd5/6jBuILiugJSa7epvdZAtyVo1xOf2BN7cX/4Ul/SE11YjgyjLr1b3U4SY/Bc8w01Pmb+wKBgQDZ4Nq8u+k4GQh6G9pFSwgDxMnPUGX4vnWew7zsyy6z45tXuzFZrvpuzWTUUtnGalzXYGaUqm5ivmmP9+CCZBWaxZkSTF8ONRm1OXTRCJlF57AzXZVVc4+inhM8WnX6KIN/FDu4nlTf7wN6J42BcqOkz8KS9N7twpYartJnTPG7qwKBgQDhqVUHLtL/erYadSqvslhH3CJCaXDRLJoxndx/kiSjko2WBMpBdPlkbro/FlhOB4fIfAj9UDMcAiE6TnpWG1qmsr3P0u+3MNEdGLZ6kgz6HR3LN722LbbIw7djStIcNjURjCDwQnfqMi0scfBcOwWW1EzL7XotEhWXwXg+ipd4OQKBgQCotysK7UQ6sX/T9s99yw1IxdE0nWBpTysLpy0b/HaMzFqVhBpCBXJd7OUAWavTrrd3/GlTA+r4wdRCrMMIlXH5aLwQ5FzTRqFCqVxhJhRygmf6TqR+CD+YwGnK2Y30Cf1RoZxhaRH2WkJKDGjSbbB0xoE4hTA/0uejf+7kGTwzgwKBgBgcuEy5fxR5O+HkV/Lay/rrHznbJxOEJ/EiV2WDKDi1Acp1QZAKb1aguqx15j7t9exGUr6Y5eCfAFOQfzlePJuLthe5APEsuzv9nslnVusamWKkxoWl6h36OYQjTf1FCgOD7QCjhaiKKQQLsZGigmMKy2D5utIWQdNoLnlhayan";

    // 汇付公钥，用于对汇付返回报文进行签名验证
    public static final String DEMO_RSA_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkmP0eyQVeGHVxk/4+Zq9R6tm8vmQZaMAvtvy5D/Ki3lvhfRn8T3R3vP5xTpp2zAtmZzFnc1k4DswYBsv7lsxwseoJ3sIM6of6NYnf+39CK+NhKSsdDNDET2KCxD5Gip3WJVtgP3P4w3P/U2jCi8Xzm9sxy3XZ3TSZuokvX77UnfBZTFMuGjCmZFcuM6VjDOxoaEtnYhAVLOQItb3Jr1vvIg4vrhCWBus9YVgl3Ua5qtTccmpspnFbY3ix0UFrmHczTaPWrxKMrnEIDurgmMPXPiyR67Z/AcvcJ8vgvaVHnINmDb0hlRUkI623P9dO/fPswaNIEj0ZeoZHcdLya07swIDAQAB";

    static {
        MerConfig merConfig = new MerConfig();
        merConfig.setProcutId(DEMO_PRODUCT_ID);
        merConfig.setSysId(DEMO_SYS_ID);
        merConfig.setRsaPrivateKey(DEMO_RSA_PRIVATE_KEY);
        merConfig.setRsaPublicKey(DEMO_RSA_PUBLIC_KEY);
        try {
            BasePay.initWithMerConfig(merConfig);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }


    @Override
    public Object jsPay(DougongRequestParam requestParam) {
        try {
            Map<String, Object> map = JsonUtils.fromJson(JsonUtils.toJson(requestParam), Map.class);
            //3. 发起API调用
            Map<String, Object> response = BasePayRequest.requestBasePay("v3/trade/payment/jspay", map, null, false);
            return response;
        } catch (Exception e) {
            log.error("error", e);
        }
        return new Object();
    }
}
