package com.liquidnet.service.goblin.test;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.param.dougong.DougongRequestParam;
import com.liquidnet.service.goblin.service.IGoblinDougongPayService;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class GoblinDougongPayServiceImplTest {

    @Autowired
    private IGoblinDougongPayService goblinDougongPayService;


    @Test
    public void jsPay(){
        HashMap<String, Object> goods1 = new HashMap<>();
        goods1.put("id", "1");
        goods1.put("name", "手环");
        goods1.put("price", "1");
        goods1.put("number", 1);

        HashMap<String, Object> goods2 = new HashMap<>();
        goods2.put("id", "2");
        goods2.put("name", "面额充值50元");
        goods2.put("price", "50");
        goods2.put("number", 1);


        // 商品列表
        ArrayList<Map<String, Object>> goodsList = new ArrayList<>();
        goodsList.add(goods1);
        goodsList.add(goods2);
        // 商品描述
        String goodsDesc = "手环充值";
        // 商品金额
        BigDecimal totalAmt = new BigDecimal("51.00");
        // 商品请求流水号
        String setReqSeqId = "rQ20250704120340912341";
        // 请求日期
        String reqDate = "20250704";
        // 交易类型
        String tradeType = "T_MINIAPP";

        DougongRequestParam requestParam = new DougongRequestParam();
        requestParam.setReqDate(reqDate);
        requestParam.setReqSeqId(setReqSeqId);
        requestParam.setHuifuId("6666000109133323");//TODO 配置
        requestParam.setGoodsDesc(goodsDesc);
        requestParam.setTradeType(tradeType);
        requestParam.setTransAmt(totalAmt.toString());
        requestParam.setTimeExpire("20250718235959"); //TODO 在计算
        requestParam.setNotifyUrl("http://www.baidu.com");//TODO 配置

        ArrayList<DougongRequestParam.WxDataGoodsDetail> wxDataGoodsDetails = new ArrayList<>();

        for (Map<String, Object> stringObjectMap : goodsList) {
            DougongRequestParam.WxDataGoodsDetail wxDataGoodsDetail = new DougongRequestParam.WxDataGoodsDetail();
            wxDataGoodsDetail.setGoodsId(String.valueOf(stringObjectMap.get("id")));
            wxDataGoodsDetail.setGoodsName(String.valueOf(stringObjectMap.get("name")));
            wxDataGoodsDetail.setPrice(String.valueOf(stringObjectMap.get("price")));
            wxDataGoodsDetail.setQuantity((Integer)stringObjectMap.get("number"));
            wxDataGoodsDetails.add(wxDataGoodsDetail);
        }

        DougongRequestParam.WxDataDetail wxDataDetail = new DougongRequestParam.WxDataDetail();
        wxDataDetail.setCostPrice(totalAmt.toString());
        wxDataDetail.setGoodsDetail(wxDataGoodsDetails);

        DougongRequestParam.WxData wxData = new DougongRequestParam.WxData();
        wxData.setSubAppid("wxdfe9a5d141f96685");//TODO 配置
        wxData.setSubOpenid("o8jhotzittQSetZ-N0Yj4Hz91Rqc"); //TODO 前端带过来
        wxData.setBody(goodsDesc);
        wxData.setDetail(wxDataDetail);

        requestParam.setWxData(JsonUtils.toJson(wxData));

        System.out.println(goblinDougongPayService.jsPay(requestParam));
    }

}
