package com.liquidnet.service.candy.vo;

import com.liquidnet.service.candy.dto.CandyCouponInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel
public class CandyCouponBasicVo implements Serializable, Cloneable {
    /* --- --- --- CandyCoupon */
    @ApiModelProperty(value = "标题")
    private String title;
    @ApiModelProperty(value = "标注")
    private String label;
    @ApiModelProperty(value = "须知")
    private String notice;
    @ApiModelProperty(value = "业务类别[0-全场｜1-演出｜2-商品｜3-优先购]")
    private Integer busiType;
    @ApiModelProperty(value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券 | 101-优先券]")
    private Integer couType;
    @ApiModelProperty(value = "[0-用户输入兑换｜1-发放至用户｜2-积分兑换｜3-发放需领取｜4-会员专属]")
    private Integer bindType;
    @ApiModelProperty(value = "折扣")
    private BigDecimal discount;
    @ApiModelProperty(value = "面值")
    private BigDecimal valFace;
    @ApiModelProperty(value = "满减~满")
    private BigDecimal valOver;
    @ApiModelProperty(value = "满减~减")
    private BigDecimal valMinus;
    @ApiModelProperty(value = "过期时间")
    private String expireAt;

    /* --- --- --- CandyCouponRule */
    private List<CandyCouponRulesVo> useRules;

    private static final CandyCouponBasicVo obj = new CandyCouponBasicVo();

    public static CandyCouponBasicVo getNew() {
        try {
            return (CandyCouponBasicVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponBasicVo();
        }
    }

    public CandyCouponBasicVo copy(CandyCouponInfoDto source) {
        if (null == source) return this;
        return this;
    }
}
