package com.liquidnet.service.galaxy.dto.bo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: nft转让最新记录
 * @class: GalaxyTransferNftInfoBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/8/12 13:36
 */
@Data
public class GalaxyTransferNftInfoBo implements Serializable,Cloneable{
    /**
     * 转让流水号（平台转让订单id）
     */
    private String transOrderId;
    /**
     * nft唯一资产碎片id
     */
    private String nftId;
    /**
     * 转让发起人用户id
     */
    private String userId;
    /**
     * 转让发起人区块链地址
     */
    private String address;
    /**
     * 接收者userId
     */
    private String receiveUserId;
    /**
     * 接收者区块链地址
     */
    private String receiveAddress;
    /**
     * nft当前拥有者用户id(转让成功后更新)
     */
    private String ownerUserId;
    /**
     * nft当前拥有者addr(转让成功后更新)
     */
    private String ownerAddress;
    /**
     * 转让hash
     */
    private String transferHash;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * 路由类型
     */
    private String routerType;
    /**
     * 转让状态(0转让中 1转让成功 2转让失败 )
     */
    private String transferStatus;
    /**
     * 错误码
     */
    private String errorCode;
    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 创建时间
     */
    private String createdAt;
    /**
     * 修改时间
     */
    private String updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyTransferNftInfoBo obj = new GalaxyTransferNftInfoBo();

    public static GalaxyTransferNftInfoBo getNew() {
        try {
            return (GalaxyTransferNftInfoBo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyTransferNftInfoBo();
        }
    }
}
