package com.liquidnet.common.third.zxlnft.constant;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlnftEnum
 * @Package com.liquidnet.common.third.zxlnft.constant
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/25 11:16
 */
public class ZxlnftEnum {
    /**
     * txType 交易类别， 1:发行 2:购买 3:转移 4:设置价格 5:设置状态
     */

    /**
     * 图片检测结果建议
     */
    public enum SuggestionEnum{
        BLOCK("Block","建议屏蔽"),
        REVIEW("Review","建议复审"),
        PASS("Pass","建议通过");

        private String code;
        private String message;
        SuggestionEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public SuggestionEnum getEnumByCode(String code){
            SuggestionEnum[] arry = SuggestionEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 下发用户信息查询验证码(使用场景)
     */
    public enum UseSceneEnum{
        QUERY("1","查询用户信息"),
        BINDING("2","nft平台绑定地址"); //该类型只用于nft平台自身地址绑定

        private String code;
        private String message;
        UseSceneEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public UseSceneEnum getEnumByCode(String code){
            UseSceneEnum[] arry = UseSceneEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }
    /**
     * 注册类型
     */
    public enum RegisterTypeEnum{
        PERSON("1","企业"),
        COMPANY("2","个人");


        private String code;
        private String message;
        RegisterTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public RegisterTypeEnum getEnumByCode(String code){
            RegisterTypeEnum[] arry = RegisterTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 支付状态
     */
    public enum SellStatusEnum{
        CAN_SELL("1","可售"),
        CAN_NOT_SELL("2","不可售");


        private String code;
        private String message;
        SellStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public SellStatusEnum getEnumByCode(String code){
            SellStatusEnum[] arry = SellStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    public enum CardTypeEnum{
//         1-身份证 2-护照 3-港澳通行证 4-台湾通行证 5-外国人永居身份证 6-港澳台居民居住证 7-其它
        ID_CARD("1","身份证"),
        ID_CARD_PP("2","护照"),
        ID_CARD_HM("3","港澳通行证"),
        ID_CARD_TW("4","台湾通行证"),
        ID_CARD_FOR("5","外国人永居身份证"),
        ID_CARD_HMTW("6","港澳台居民居住证"),
        ID_CARD_OTHER("7","其它");


        private String code;
        private String message;
        CardTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public CardTypeEnum getEnumByCode(String code){
            CardTypeEnum[] arry = CardTypeEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 标记任务状态
     */
    public enum TaskStatusEnum{
        PROCESSING("2","任务执行中"),
        TASK_SUCCESS("7","任务成功"),
        TASK_FAIL("10","任务失败");


        private String code;
        private String message;
        TaskStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public TaskStatusEnum getEnumByCode(String code){
            TaskStatusEnum[] arry = TaskStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getMessage(){
            return message;
        }
    }

    /**
     * 标记任务状态
     */
    public enum UserBindStatusEnum{
        BIND_PROCESSING("1","绑定中"),
        BIND_SUCCESS("2","已绑定"),
        BIND_FAIL("3","绑定失败"),
        BIND_CANNOT_QUERY("4","未发起过绑定(未查询到)");


        private String code;
        private String message;
        UserBindStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public UserBindStatusEnum getEnumByCode(String code){
            UserBindStatusEnum[] arry = UserBindStatusEnum.values();
            for (int i = 0; i < arry.length; i++) {
                if (arry[i].getCode().equals(code)) {
                    return arry[i];
                }
            }
            return null;
        }

        public String getCode() {
            return code;
        }

        public String getMessage(){
            return message;
        }
    }
}
