package com.liquidnet.service.consumer.galaxy.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.constant.GalaxyConstant;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftOrderVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxySeriesNftInfoVo;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyUserInfoVo;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

@Slf4j
@Component
public class DataUtils {
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private QueueUtil queueUtil;

    private long keyExpireTime = 3600*24*30;

    public GalaxyUserInfoBo getGalaxyUserInfo(String routerType, String userId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KEY_GALAXY_USER.concat(routerType).concat(":") + userId);
        if(obj!=null){
            return (GalaxyUserInfoBo) obj;
        }else {
            GalaxyUserInfoVo userInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("userId").is(userId)), GalaxyUserInfoVo.class, GalaxyUserInfoVo.class.getSimpleName());
            if (userInfoVo == null) {
                return null;
            }
            GalaxyUserInfoBo userInfoBo = GalaxyUserInfoBo.getNew();
            BeanUtil.copy(userInfoVo,userInfoBo);

            redisUtil.set(GalaxyConstant.REDIS_KEY_GALAXY_USER.concat(routerType).concat(":") + userId, userInfoBo);
            return userInfoBo;
        }
    }

    public GalaxyNftOrderBo getNftOrderBo(String routerType, String nftOrderPayId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KEY_GALAXY_TRADE.concat(routerType).concat(":") + nftOrderPayId);
        if(obj!=null){
            return (GalaxyNftOrderBo) obj;
        }else {
            GalaxyNftOrderVo nftOrderVo = mongoTemplate.findOne(Query.query(Criteria.where("nftOrderPayId").is(nftOrderPayId)), GalaxyNftOrderVo.class, GalaxyNftOrderVo.class.getSimpleName());
            if (nftOrderVo == null) {
                return null;
            }
            GalaxyNftOrderBo nftOrderBo = GalaxyNftOrderBo.getNew();
            BeanUtil.copy(nftOrderVo,nftOrderBo);
            redisUtil.set(GalaxyConstant.REDIS_KEY_GALAXY_TRADE.concat(routerType).concat(":") + nftOrderPayId, nftOrderBo);
            return nftOrderBo;
        }
    }

    public GalaxySeriesNftInfoBo getSeriesNftInfoBo(String routerType, String skuId) {
        Object obj = redisUtil.get(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT.concat(routerType).concat(":") + skuId);
        if(obj!=null){
            return (GalaxySeriesNftInfoBo) obj;
        }else {
            GalaxySeriesNftInfoVo seriesNftInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("skuId").is(skuId)), GalaxySeriesNftInfoVo.class, GalaxySeriesNftInfoVo.class.getSimpleName());
            if (seriesNftInfoVo == null) {
                return null;
            }
            GalaxySeriesNftInfoBo seriesNftInfoBo = GalaxySeriesNftInfoBo.getNew();
            BeanUtil.copy(seriesNftInfoVo,seriesNftInfoBo);
            redisUtil.set(GalaxyConstant.REDIS_KEY_GALAXY_SERIES_NFT.concat(routerType).concat(":") + skuId, seriesNftInfoBo);
            return seriesNftInfoBo;
        }
    }

    public void updateNftOrderBuyTaskId(String routerType,String nftOrderPayId,GalaxyNftOrderBo nftOrderBo) {
        redisUtil.set(GalaxyConstant.REDIS_KEY_GALAXY_TRADE.concat(routerType).concat(":") + nftOrderPayId,nftOrderBo,keyExpireTime);

        Query query = Query.query(Criteria.where("nftOrderPayId").is(nftOrderPayId));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(nftOrderBo)));
        update.set("nftBuyTaskId", nftOrderBo.getNftBuyTaskId());
        String nowTimeStr = DateUtil.Formatter.yyyyMMddHHmmss.format(LocalDateTime.now());
        update.set("updatedAt",nowTimeStr);
        UpdateResult result = mongoTemplate.updateFirst(query,update, GalaxyNftOrderVo.class,GalaxyNftOrderVo.class.getSimpleName());
        log.info("updateNftOrderInfo result:{}",result.toString());

        try{
            queueUtil.sendMySqlRedis(
                    SqlMapping.get("galaxy_nft_order_info.updateNftBuyTaskId"),
                    new Object[]{nftOrderBo.getNftBuyTaskId(),LocalDateTime.now(),nftOrderBo.getNftOrderPayId()}
                    , MQConst.GalaxyQueue.SQL_NFT_TRADE_INFO.getKey()
            );
        }catch(Exception e){
            log.error(e.getMessage(),e);
            log.error("#setNftTradeInfo error ==> MESSAGE:{}",e.getMessage());
        }
    }

}
