package com.liquidnet.service.consumer.galaxy.utils;

import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.galaxy.utils.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.LinkedList;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: QueueUtil
 * @Package com.liquidnet.service.galaxy.utils
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/25 15:35
 */
@Component
public class QueueUtil {
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * 给 REDIS 队列发送消息 数据库相关
     *
     * @param sql  sql语句
     * @param data 需要操作的数据
     * @return
     */
    public boolean sendMySqlRedis(String sql, Object[] data , String redisKey) {
        try {
            LinkedList<String> sqls = ObjectUtil.cloneLinkedListStr();
            sqls.add(sql);
            LinkedList<Object[]> sqlsData = ObjectUtil.cloneLinkedListObj();
            sqlsData.add(data);
            String sqlData = SqlMapping.gets(sqls, sqlsData);

            HashMap<String, String> map = ObjectUtil.cloneHashMapStringAndString();
            map.put("message", sqlData);
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey(redisKey);
            stringRedisTemplate.opsForStream().add(record);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
