package com.liquidnet.service.goblin.service.impl.manage;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCertificationParam;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtCompleteParam;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCertificationVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMgtCertificationService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

@Slf4j
@Service
public class GoblinStoreMgtCertificationServiceImpl implements IGoblinStoreMgtCertificationService {
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinMongoUtils goblinMongoUtils;

    @Override
    public GoblinStoreInfoVo certificationInformationProcessing(GoblinStoreMgtCertificationParam param, GoblinStoreInfoVo storeInfoVo) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();

//        if (null == storeInfoVo) {
        if (null == storeInfoVo || storeInfoVo.getStoreId().equals("1")) {// TODO: 2022/1/6 zhanggb del
            storeInfoVo = GoblinStoreInfoVo.getNew();
            storeInfoVo.setStoreId(IDGenerator.get32UUID());
            storeInfoVo.setUid(uid);
            storeInfoVo.setStatus("0");
            storeInfoVo.setStoreType("0");
            storeInfoVo.setCertType(param.getCertType());
            storeInfoVo.setDelFlg("0");
            storeInfoVo.setCreatedAt(now);
            storeInfoVo.setCreatedBy(uid);
            storeInfoVo.setUpdatedBy(uid);
            storeInfoVo.setUpdatedAt(now);

            GoblinStoreCertificationVo storeCertificationVo = param.initStoreCertificationVo();
            storeInfoVo.setCertificationVo(storeCertificationVo);

            goblinMongoUtils.setStoreInfoVo(storeInfoVo);
            goblinRedisUtils.addStoreId(uid, storeInfoVo.getStoreId());
            // TODO: 2022/1/6 zhanggb redis
//            goblinRedisUtils.setStoreInfoVo(storeInfoVo);

            LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
            LinkedList<Object[]> initStoreInfoObjs = CollectionUtil.linkedListObjectArr();
            toMqSqls.add(SqlMapping.get("goblin_store_info.insert_by_cert"));
            initStoreInfoObjs.add(new Object[]{
                    storeInfoVo.getStoreId(), storeInfoVo.getUid(), storeInfoVo.getStatus(), storeInfoVo.getStoreType(),
                    storeInfoVo.getCertType(), storeInfoVo.getCreatedBy(), storeInfoVo.getCreatedAt()
            });
            toMqSqls.add(SqlMapping.get("goblin_store_certification.insert_by_cert"));
            LinkedList<Object[]> initStoreCertificationObjs = CollectionUtil.linkedListObjectArr();
            initStoreCertificationObjs.add(new Object[]{
                    storeInfoVo.getStoreId(), storeCertificationVo.getPersonCertType(), storeCertificationVo.getPersonName(),
                    storeCertificationVo.getPersonCertCode(), storeCertificationVo.getPersonCertValidity(), storeCertificationVo.getPersonCertLasting(),
                    storeCertificationVo.getPersonCertFpic(), storeCertificationVo.getPersonCertBpic(), storeCertificationVo.getPersonCertSpic(),
                    storeCertificationVo.getProvinceId(), storeCertificationVo.getProvinceName(), storeCertificationVo.getCityId(),
                    storeCertificationVo.getCityName(), storeCertificationVo.getCountyId(), storeCertificationVo.getCountyName(),
                    storeCertificationVo.getBusAddress(), storeCertificationVo.getBusName(), storeCertificationVo.getBusCertCode(),
                    storeCertificationVo.getBusCertValidity(), storeCertificationVo.getBusCertLasting(), storeCertificationVo.getBusCertPic(),
                    storeCertificationVo.getBusQualityPic(), storeInfoVo.getCreatedBy(), storeInfoVo.getCreatedAt()
            });
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.gets(toMqSqls, initStoreInfoObjs, initStoreCertificationObjs));
            return storeInfoVo;
        } else {
            storeInfoVo.setStatus("0");
            storeInfoVo.setStoreType("0");
            storeInfoVo.setUpdatedBy(uid);
            storeInfoVo.setUpdatedAt(now);

            GoblinStoreCertificationVo storeCertificationVo = param.initStoreCertificationVo();
            storeInfoVo.setCertificationVo(storeCertificationVo);

            if (goblinMongoUtils.updateStoreInfoVo(storeInfoVo)) {
                // TODO: 2022/1/6 zhanggb redis
//                goblinRedisUtils.setStoreInfoVo(storeInfoVo);

                LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> updateStoreInfoObjs = CollectionUtil.linkedListObjectArr();
                toMqSqls.add(SqlMapping.get("goblin_store_info.update_by_cert1"));
                updateStoreInfoObjs.add(new Object[]{
                        storeInfoVo.getStoreType(), storeInfoVo.getCertType(),
                        storeInfoVo.getUpdatedBy(), storeInfoVo.getUpdatedAt(), storeInfoVo.getStoreId(),
                });
                toMqSqls.add(SqlMapping.get("goblin_store_certification.update_by_cert"));
                LinkedList<Object[]> updateStoreCertificationObjs = CollectionUtil.linkedListObjectArr();
                updateStoreCertificationObjs.add(new Object[]{
                        storeCertificationVo.getPersonCertType(), storeCertificationVo.getPersonName(),
                        storeCertificationVo.getPersonCertCode(), storeCertificationVo.getPersonCertValidity(), storeCertificationVo.getPersonCertLasting(),
                        storeCertificationVo.getPersonCertFpic(), storeCertificationVo.getPersonCertBpic(), storeCertificationVo.getPersonCertSpic(),
                        storeCertificationVo.getProvinceId(), storeCertificationVo.getProvinceName(), storeCertificationVo.getCityId(),
                        storeCertificationVo.getCityName(), storeCertificationVo.getCountyId(), storeCertificationVo.getCountyName(),
                        storeCertificationVo.getBusAddress(), storeCertificationVo.getBusName(), storeCertificationVo.getBusCertCode(),
                        storeCertificationVo.getBusCertValidity(), storeCertificationVo.getBusCertLasting(), storeCertificationVo.getBusCertPic(),
                        storeCertificationVo.getBusQualityPic(), storeInfoVo.getUpdatedBy(), storeInfoVo.getUpdatedAt(), storeInfoVo.getStoreId()
                });
                queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                        SqlMapping.gets(toMqSqls, updateStoreInfoObjs, updateStoreCertificationObjs));
                return storeInfoVo;
            }
        }
        return storeInfoVo;
    }

    @Override
    public boolean certificationCompleteProcessing(GoblinStoreMgtCompleteParam param, GoblinStoreInfoVo storeInfoVo) {
        storeInfoVo.setUpdatedAt(LocalDateTime.now());
        storeInfoVo.setUpdatedBy(CurrentUtil.getCurrentUid());
        if (goblinMongoUtils.updateStoreInfoVo(param.completeStoreInfoVo(storeInfoVo))) {
            // TODO: 2022/1/6 zhanggb redis

//            LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
//            LinkedList<Object[]> updateStoreInfoObjs = CollectionUtil.linkedListObjectArr();
//            toMqSqls.add(SqlMapping.get("goblin_store_info.update_by_cert2"));
//            updateStoreInfoObjs.add(new Object[]{
//                    storeInfoVo.getStoreName(), storeInfoVo.getLogoPic(), storeInfoVo.getBackgroundPic(), storeInfoVo.getIntroduce(),
//                    storeInfoVo.getStoreType(), storeInfoVo.getUpdatedBy(), storeInfoVo.getUpdatedAt(), storeInfoVo.getStoreId()
//            });
            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(),
                    SqlMapping.get("goblin_store_info.update_by_cert2",
                            storeInfoVo.getStoreName(), storeInfoVo.getLogoPic(), storeInfoVo.getBackgroundPic(), storeInfoVo.getIntroduce(),
                            storeInfoVo.getStatus(), storeInfoVo.getStoreType(), storeInfoVo.getUpdatedBy(), storeInfoVo.getUpdatedAt(), storeInfoVo.getStoreId())
            );
            return true;
        }
        return false;
    }

    @Override
    public boolean certificationCancelProcessing(String storeId, String uid) {
        LocalDateTime now = LocalDateTime.now();
        if (goblinMongoUtils.delStoreInfoVo(storeId, uid, now)) {
            goblinRedisUtils.delStoreId(CurrentUtil.getCurrentUid(), storeId);
            goblinRedisUtils.delStoreInfoVo(storeId);

            List<String> delSpuIdList = goblinMongoUtils.delGoodsInfoVoByStoreId(storeId, uid, now);
            delSpuIdList.forEach(spuId -> goblinRedisUtils.delGoodsInfoVo(spuId));
            List<String> delSkuIdList = goblinMongoUtils.delGoodsSkuInfoVoByStoreId(storeId, uid, now);
            delSkuIdList.forEach(skuId -> goblinRedisUtils.delGoodsSkuInfoVo(skuId));

            LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
            toMqSqls.add(SqlMapping.get("goblin_store_info.update_by_del"));
            LinkedList<Object[]> updateStoreObjs = CollectionUtil.linkedListObjectArr();
            updateStoreObjs.add(new Object[]{uid, now, storeId});
            toMqSqls.add(SqlMapping.get("goblin_store_certification.update_by_del"));

            toMqSqls.add(SqlMapping.get("goblin_goods.update_by_del"));
            LinkedList<Object[]> updateGoodsObjs = CollectionUtil.linkedListObjectArr();
            updateGoodsObjs.add(new Object[]{uid, now, uid, now, storeId});
            toMqSqls.add(SqlMapping.get("goblin_goods_sku.update_by_del"));

            // TODO: 2022/1/10 redis+规格｜标签｜服务支持关联入库

            queueUtils.sendMsgByRedis(MQConst.GoblinQueue.SQL_STORE.getKey(), SqlMapping.gets(toMqSqls, updateStoreObjs, updateStoreObjs, updateGoodsObjs, updateGoodsObjs));
        }
        return false;
    }
}
