package com.liquidnet.service.stone.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoSimpleVo;
import com.liquidnet.service.stone.dto.StoneScoreListDto;
import com.liquidnet.service.stone.service.IStoneScoreUserService;
import com.liquidnet.service.stone.util.InnerUtils;
import com.liquidnet.service.stone.util.StoneRedisUtils;
import com.liquidnet.service.stone.vo.StoneUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * <p>
 * 积分用户表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Service
public class StoneScoreUserServiceImpl implements IStoneScoreUserService {

    @Autowired
    StoneRedisUtils redisUtils;

    @Override
    public StoneScoreListDto stoneUserInfo() {
        try {
            String uid = CurrentUtil.getCurrentUid();
            StoneScoreListDto vo = StoneScoreListDto.getNew();
            AdamUserInfoSimpleVo userVo = InnerUtils.getUserInfo();
            StoneUserVo userTaskVo = redisUtils.getUserData(uid);
            int rest = redisUtils.getUserScoreRest(uid);
            int use = redisUtils.getUserScoreUse(uid);
            vo.setAvatar(userVo.getAvatar());
            vo.setMobile(userVo.getMobile());
            vo.setNickName(userVo.getNickname());
            vo.setScoreAll(BigDecimal.valueOf(use + rest));
            vo.setScoreRest(BigDecimal.valueOf(rest));
            vo.setScoreUse(BigDecimal.valueOf(use));
            vo.setStatus(userTaskVo.getStatus());
            return vo;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
