package com.liquidnet.client.admin.zhengzai.kylin.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单对象 kylin_order_tickets
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
public class KylinOrderTickets extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Integer mid;

    /** order_tickets_id */
    @Excel(name = "order_tickets_id")
    private String orderTicketsId;

    /** 用户id */
    @Excel(name = "用户id")
    private String userId;

    /** 用户昵称 */
    @Excel(name = "用户昵称")
    private String userName;

    /** 用户手机号 */
    @Excel(name = "用户手机号")
    private String userMobile;

    /** 演出名称 */
    @Excel(name = "演出名称")
    private String performanceTitle;

    /** 订单号 */
    @Excel(name = "订单号")
    private String orderCode;

    /** 二维码地址 */
    @Excel(name = "二维码地址")
    private String qrCode;

    /** 下单方式 */
    @Excel(name = "下单方式")
    private String orderType;

    /** 下单版本 */
    @Excel(name = "下单版本")
    private String orderVersion;

    /** 数量 */
    @Excel(name = "数量")
    private String number;

    /** 单价 */
    @Excel(name = "单价")
    private BigDecimal price;

    /** 会员单价 */
    @Excel(name = "会员单价")
    private BigDecimal priceMember;

    /** 应付价格 */
    @Excel(name = "应付价格")
    private BigDecimal priceTotal;

    /** 优惠价格 */
    @Excel(name = "优惠价格")
    private BigDecimal priceVoucher;

    /** 实付价格 */
    @Excel(name = "实付价格")
    private BigDecimal priceActual;

    /** 快递价格 */
    @Excel(name = "快递价格")
    private BigDecimal priceExpress;

    /** 退款价格 */
    @Excel(name = "退款价格")
    private BigDecimal priceRefund;

    /** 退款张数 */
    @Excel(name = "退款张数")
    private BigDecimal priceNumber;

    /** 选择支付方式 */
    @Excel(name = "选择支付方式")
    private String payType;

    /** 实际支付方式 */
    @Excel(name = "实际支付方式")
    private String paymentType;

    /** 支付时间 */
    @Excel(name = "支付时间")
    private String timePay;

    /** 收货人 */
    @Excel(name = "收货人")
    private String expressContacts;

    /** 收货地址 */
    @Excel(name = "收货地址")
    private String expressAddress;

    /** 收货人联系方式 */
    @Excel(name = "收货人联系方式")
    private String expressPhone;

    /** 券使用类别 */
    @Excel(name = "券使用类别")
    private String couponType;

    /** 取票方式 电子票electronic快递票express */
    @Excel(name = "取票方式 电子票electronic快递票express")
    private String getTicketType;

    /** 直播用取票观演码，隔开 */
    @Excel(name = "直播用取票观演码，隔开")
    private String getTicketDescribe;

    /** 订单过期时间 */
    @Excel(name = "订单过期时间")
    private String payCountdownMinute;

    /** comment */
    @Excel(name = "comment")
    private String comment;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    public void setMid(Integer mid) 
    {
        this.mid = mid;
    }

    public Integer getMid() 
    {
        return mid;
    }
    public void setOrderTicketsId(String orderTicketsId) 
    {
        this.orderTicketsId = orderTicketsId;
    }

    public String getOrderTicketsId() 
    {
        return orderTicketsId;
    }
    public void setUserId(String userId) 
    {
        this.userId = userId;
    }

    public String getUserId() 
    {
        return userId;
    }
    public void setUserName(String userName) 
    {
        this.userName = userName;
    }

    public String getUserName() 
    {
        return userName;
    }
    public void setUserMobile(String userMobile) 
    {
        this.userMobile = userMobile;
    }

    public String getUserMobile() 
    {
        return userMobile;
    }
    public void setPerformanceTitle(String performanceTitle) 
    {
        this.performanceTitle = performanceTitle;
    }

    public String getPerformanceTitle() 
    {
        return performanceTitle;
    }
    public void setOrderCode(String orderCode) 
    {
        this.orderCode = orderCode;
    }

    public String getOrderCode() 
    {
        return orderCode;
    }
    public void setQrCode(String qrCode) 
    {
        this.qrCode = qrCode;
    }

    public String getQrCode() 
    {
        return qrCode;
    }
    public void setOrderType(String orderType) 
    {
        this.orderType = orderType;
    }

    public String getOrderType() 
    {
        return orderType;
    }
    public void setOrderVersion(String orderVersion) 
    {
        this.orderVersion = orderVersion;
    }

    public String getOrderVersion() 
    {
        return orderVersion;
    }
    public void setNumber(String number) 
    {
        this.number = number;
    }

    public String getNumber() 
    {
        return number;
    }
    public void setPrice(BigDecimal price) 
    {
        this.price = price;
    }

    public BigDecimal getPrice() 
    {
        return price;
    }
    public void setPriceMember(BigDecimal priceMember) 
    {
        this.priceMember = priceMember;
    }

    public BigDecimal getPriceMember() 
    {
        return priceMember;
    }
    public void setPriceTotal(BigDecimal priceTotal) 
    {
        this.priceTotal = priceTotal;
    }

    public BigDecimal getPriceTotal() 
    {
        return priceTotal;
    }
    public void setPriceVoucher(BigDecimal priceVoucher) 
    {
        this.priceVoucher = priceVoucher;
    }

    public BigDecimal getPriceVoucher() 
    {
        return priceVoucher;
    }
    public void setPriceActual(BigDecimal priceActual) 
    {
        this.priceActual = priceActual;
    }

    public BigDecimal getPriceActual() 
    {
        return priceActual;
    }
    public void setPriceExpress(BigDecimal priceExpress) 
    {
        this.priceExpress = priceExpress;
    }

    public BigDecimal getPriceExpress() 
    {
        return priceExpress;
    }
    public void setPriceRefund(BigDecimal priceRefund) 
    {
        this.priceRefund = priceRefund;
    }

    public BigDecimal getPriceRefund() 
    {
        return priceRefund;
    }
    public void setPriceNumber(BigDecimal priceNumber) 
    {
        this.priceNumber = priceNumber;
    }

    public BigDecimal getPriceNumber() 
    {
        return priceNumber;
    }
    public void setPayType(String payType) 
    {
        this.payType = payType;
    }

    public String getPayType() 
    {
        return payType;
    }
    public void setPaymentType(String paymentType) 
    {
        this.paymentType = paymentType;
    }

    public String getPaymentType() 
    {
        return paymentType;
    }
    public void setTimePay(String timePay) 
    {
        this.timePay = timePay;
    }

    public String getTimePay() 
    {
        return timePay;
    }
    public void setExpressContacts(String expressContacts) 
    {
        this.expressContacts = expressContacts;
    }

    public String getExpressContacts() 
    {
        return expressContacts;
    }
    public void setExpressAddress(String expressAddress) 
    {
        this.expressAddress = expressAddress;
    }

    public String getExpressAddress() 
    {
        return expressAddress;
    }
    public void setExpressPhone(String expressPhone) 
    {
        this.expressPhone = expressPhone;
    }

    public String getExpressPhone() 
    {
        return expressPhone;
    }
    public void setCouponType(String couponType) 
    {
        this.couponType = couponType;
    }

    public String getCouponType() 
    {
        return couponType;
    }
    public void setGetTicketType(String getTicketType) 
    {
        this.getTicketType = getTicketType;
    }

    public String getGetTicketType() 
    {
        return getTicketType;
    }
    public void setGetTicketDescribe(String getTicketDescribe) 
    {
        this.getTicketDescribe = getTicketDescribe;
    }

    public String getGetTicketDescribe() 
    {
        return getTicketDescribe;
    }
    public void setPayCountdownMinute(String payCountdownMinute) 
    {
        this.payCountdownMinute = payCountdownMinute;
    }

    public String getPayCountdownMinute() 
    {
        return payCountdownMinute;
    }
    public void setComment(String comment) 
    {
        this.comment = comment;
    }

    public String getComment() 
    {
        return comment;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("mid", getMid())
            .append("orderTicketsId", getOrderTicketsId())
            .append("userId", getUserId())
            .append("userName", getUserName())
            .append("userMobile", getUserMobile())
            .append("performanceTitle", getPerformanceTitle())
            .append("orderCode", getOrderCode())
            .append("qrCode", getQrCode())
            .append("orderType", getOrderType())
            .append("orderVersion", getOrderVersion())
            .append("number", getNumber())
            .append("price", getPrice())
            .append("priceMember", getPriceMember())
            .append("priceTotal", getPriceTotal())
            .append("priceVoucher", getPriceVoucher())
            .append("priceActual", getPriceActual())
            .append("priceExpress", getPriceExpress())
            .append("priceRefund", getPriceRefund())
            .append("priceNumber", getPriceNumber())
            .append("payType", getPayType())
            .append("paymentType", getPaymentType())
            .append("timePay", getTimePay())
            .append("expressContacts", getExpressContacts())
            .append("expressAddress", getExpressAddress())
            .append("expressPhone", getExpressPhone())
            .append("couponType", getCouponType())
            .append("getTicketType", getGetTicketType())
            .append("getTicketDescribe", getGetTicketDescribe())
            .append("payCountdownMinute", getPayCountdownMinute())
            .append("comment", getComment())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .toString();
    }
}
