package com.liquidnet.client.admin.zhengzai.kylin.service;

import java.util.List;
import com.liquidnet.client.admin.zhengzai.kylin.domain.KylinPerformances;

/**
 * 演出Service接口
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
public interface IKylinPerformancesService 
{
    /**
     * 查询演出
     * 
     * @param mid 演出ID
     * @return 演出
     */
    public KylinPerformances selectKylinPerformancesById(Long mid);

    /**
     * 查询演出列表
     * 
     * @param kylinPerformances 演出
     * @return 演出集合
     */
    public List<KylinPerformances> selectKylinPerformancesList(KylinPerformances kylinPerformances);

    /**
     * 新增演出
     * 
     * @param kylinPerformances 演出
     * @return 结果
     */
    public int insertKylinPerformances(KylinPerformances kylinPerformances);

    /**
     * 修改演出
     * 
     * @param kylinPerformances 演出
     * @return 结果
     */
    public int updateKylinPerformances(KylinPerformances kylinPerformances);

    /**
     * 批量删除演出
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteKylinPerformancesByIds(String ids);

    /**
     * 删除演出信息
     * 
     * @param mid 演出ID
     * @return 结果
     */
    public int deleteKylinPerformancesById(Long mid);
}
