package com.liquidnet.service.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.*;
import com.liquidnet.service.goblin.service.GoblinFrontService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import com.mongodb.BasicDBObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;

@Service
@Slf4j
public class GoblinFrontServiceImpl implements GoblinFrontService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ArrayList<GoblinFrontBannerVo> getListBanner() {
        if(!redisUtil.hasKey(GoblinRedisConst.FRONT_TOP_BANNER)){
            return null;
        }
        List<GoblinFrontBanner> list= (List<GoblinFrontBanner>) redisUtil.get(GoblinRedisConst.FRONT_TOP_BANNER);
        LocalDateTime nowTime= LocalDateTime.now();
        ArrayList<GoblinFrontBanner> goblinFrontBannerArrayList= ObjectUtil.getGoblinFrontBannerArrayList();
        //查看是否有失效的时间
        for(GoblinFrontBanner goblinFrontBanner:list){
            if(null!=goblinFrontBanner.getEndTime()){
                if( nowTime.isAfter(goblinFrontBanner.getEndTime())){
                }else{
                    goblinFrontBannerArrayList.add(goblinFrontBanner);
                }
            }
        }
        ArrayList<GoblinFrontBannerVo> list1= ObjectUtil.goblinFrontBannerVoArrayList();
        for(GoblinFrontBanner goblinFrontBanner:goblinFrontBannerArrayList){
            GoblinFrontBannerVo goblinFrontBannerVo=GoblinFrontBannerVo.getNew();
            BeanUtils.copyProperties(goblinFrontBanner,goblinFrontBannerVo);
            list1.add(goblinFrontBannerVo);
        }
        return list1;
    }
    public ArrayList<GoblinFrontBannerVo> getMiddleBanner() {
        if(!redisUtil.hasKey(GoblinRedisConst.FRONT_MIDDLE_BANNER)){
            return null;
        }
        List<GoblinFrontBanner> list= (List<GoblinFrontBanner>) redisUtil.get(GoblinRedisConst.FRONT_MIDDLE_BANNER);
        LocalDateTime nowTime= LocalDateTime.now();
        ArrayList<GoblinFrontBanner> goblinFrontBannerArrayList= ObjectUtil.getGoblinFrontBannerArrayList();
        //查看是否有失效的时间
        for(GoblinFrontBanner goblinFrontBanner:list){
            if(null!=goblinFrontBanner.getEndTime()){
                if( nowTime.isAfter(goblinFrontBanner.getEndTime())){
                }else{
                    goblinFrontBannerArrayList.add(goblinFrontBanner);
                }
            }
        }
        ArrayList<GoblinFrontBannerVo> list1= ObjectUtil.goblinFrontBannerVoArrayList();
        for(GoblinFrontBanner goblinFrontBanner:goblinFrontBannerArrayList){
            GoblinFrontBannerVo goblinFrontBannerVo=GoblinFrontBannerVo.getNew();
            BeanUtils.copyProperties(goblinFrontBanner,goblinFrontBannerVo);
            list1.add(goblinFrontBannerVo);
        }
        return list1;
    }

    @Override
    public GoblinFrontHotWord getHotWord() {
        if(!redisUtil.hasKey(GoblinRedisConst.FRONT_HOTWORD)){
            return null;
        }
       // int index= (int) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD_INDEX);
        //获得value
        List<GoblinFrontHotWord> list= (List<GoblinFrontHotWord>) redisUtil.get(GoblinRedisConst.FRONT_HOTWORD);
       /* index++;
        String hotWord="";
        redisUtil.set(GoblinRedisConst.FRONT_HOTWORD_INDEX,index);
        if(index<list.size()){
            hotWord= list.get(index).getWord();
        }else{
            hotWord= list.get(0).getWord();
        }*/
        if(null==list||list.size()==0){
            return null;
        }else{
            return list.get(0);
        }
    }

    @Override
    public GoblinFrontNavigationVoo getNavigation() {
        if(!redisUtil.hasKey(GoblinRedisConst.FRONT_NAVIGATION)){
            return null;
        }
        GoblinFrontNavigationVoo goblinFrontNavigationVoo=GoblinFrontNavigationVoo.getNew();
        List<GoblinFrontNavigation> list = (List<GoblinFrontNavigation>) redisUtil.get(GoblinRedisConst.FRONT_NAVIGATION);
        ArrayList<GoblinFrontNavigationVo> list1=ObjectUtil.getgoblinFrontNavigationVoArrayList();
        for(GoblinFrontNavigation navigation:list){
            goblinFrontNavigationVoo.setDisplayType(navigation.getDisplayType());
            GoblinFrontNavigationVo goblinFrontNavigationVo=GoblinFrontNavigationVo.getNew();
            BeanUtils.copyProperties(navigation,goblinFrontNavigationVo);
            list1.add(goblinFrontNavigationVo);
        }
        goblinFrontNavigationVoo.setList(list1);
        return goblinFrontNavigationVoo;
    }

    @Override
    public GoblinFrontSeckillVo getSeckilll() throws ParseException {
        //获得秒杀列表绑定
        List<GoblinFrontSeckill> list= (List<GoblinFrontSeckill>) redisUtil.get(GoblinRedisConst.FRONT_SECKILL);
        GoblinFrontSeckillVo goblinFrontSeckillVo=GoblinFrontSeckillVo.getNew();
        ArrayList<GoblinGoodsInfoVo> goblinGoodsInfoVoArrayList=ObjectUtil.goblinGoodsInfoVoArrayList();
        //判断是否有
        if(null!=list&&list.size()>0){
            //遍历秒杀， 找到对应的  官方、商铺
            GoblinFrontSeckill goblinFrontSeckill=list.get(0);
            boolean openBoolean=goblinFrontSeckill.getActivityType()==2;
            String ids=goblinFrontSeckill.getSelfActivityids();
            if(StringUtil.isNotBlank(ids)){
                String[] idss=ids.split(",");
                for(String id:idss){
                    String type=id.split("_")[0];
                    String idM=id.split("_")[1];
                    if(type.equals("g")){
                        //找到对应官方的活动 判断时间是否过期，
                        GoblinSelfMarketingVo goblinSelfMarketingVo=goblinRedisUtils.getSelfMarket(idM);
                        if(!StringUtil.isNotBlank(goblinFrontSeckillVo.getStartTime())){
                            goblinFrontSeckillVo.setStartTime(goblinSelfMarketingVo.getStartTime());
                            goblinFrontSeckillVo.setEndTime(goblinSelfMarketingVo.getEndTime());
                        }
                        if(goblinSelfMarketingVo==null){
                            break;
                        }
                        if(!openBoolean){
                            //效验该活动是否在当前时间
                            if(!belongCalendar(goblinSelfMarketingVo.getStartTime(),goblinSelfMarketingVo.getEndTime())){
                                //如果不是在当前时间
                                break;
                            }
                        }
                        //查看 活动绑定的 spu   sku
                        List<GoblinMarketRelationVo>  list1=goblinRedisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_PURCHASE.getValue(),goblinSelfMarketingVo.getSelfMarketId());
                        //遍历 活动表
                        for(GoblinMarketRelationVo goblinMarketRelationVo:list1){
                            //找到对应的spu商品
                            GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinMarketRelationVo.getSpuId());
                            //遍历sku 找到
                            List<String> skuList=goblinMarketRelationVo.getSkuList();
                            int sellPrice=0;
                            int i=0;
                            for(String skuId:skuList){
                                GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo= goblinRedisUtils.getGoodsSkuInfoVo(skuId);
                                if(null!=goblinGoodsSkuInfoVo){
                                    if(i==0){
                                        sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                    }
                                    if(sellPrice>goblinGoodsSkuInfoVo.getSellPrice().intValue()){
                                        sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                    }
                                }
                            }
                            goblinGoodsInfoVo.setSellPrice(new BigDecimal(sellPrice));
                            goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
                        }
                    }else if(type.equals("s")){
                        //商铺活动的vo
                        GoblinStoreMarketVo goblinStoreMarketVo=goblinRedisUtils.getGoblinStoreMarketVo(idM);
                        if(!StringUtil.isNotBlank(goblinFrontSeckillVo.getStartTime())){
                            goblinFrontSeckillVo.setStartTime(goblinStoreMarketVo.getStartTime());
                            goblinFrontSeckillVo.setEndTime(goblinStoreMarketVo.getEndTime());
                        }
                        if(goblinStoreMarketVo==null){
                            break;
                        }
                        boolean isGet=false;
                        if(openBoolean){
                            //不做效验时间直接放true
                            isGet=true;
                        }else if(goblinStoreMarketVo.getIsPre()==1&&afterCalendar(goblinStoreMarketVo.getPreTime())&&beforeCalendar(goblinStoreMarketVo.getEndTime())){
                            isGet=true;
                        }else if(goblinStoreMarketVo.getIsPre()==0&&belongCalendar(goblinStoreMarketVo.getStartTime(),goblinStoreMarketVo.getEndTime())){
                            isGet=true;
                        }
                        if(isGet){
                            //获取商铺 对应关系
                            List<GoblinMarketRelationVo>  list1=goblinRedisUtils.getMarketRelation(GoblinStatusConst.MarketPreStatus.MARKET_PRE_PURCHASE.getValue(),goblinStoreMarketVo.getStoreMarketId());
                            //获得商品
                            //遍历 活动表
                            for(GoblinMarketRelationVo goblinMarketRelationVo:list1){
                                //找到对应的spu商品
                                GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinMarketRelationVo.getSpuId());
                                //遍历sku 找到
                                List<String> skuList=goblinMarketRelationVo.getSkuList();
                                int sellPrice=0;
                                int i=0;
                                for(String skuId:skuList){
                                    GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo= goblinRedisUtils.getGoodsSkuInfoVo(skuId);
                                    if(null!=goblinGoodsSkuInfoVo){
                                        if(i==0){
                                            sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                        }
                                        if(sellPrice>goblinGoodsSkuInfoVo.getSellPrice().intValue()){
                                            sellPrice=goblinGoodsSkuInfoVo.getSellPrice().intValue();
                                        }
                                    }
                                }
                                goblinGoodsInfoVo.setSellPrice(new BigDecimal(sellPrice));
                                goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
                            }
                        }

                    }
                }
                goblinFrontSeckillVo.setGoblinGoodsInfoVoList(goblinGoodsInfoVoArrayList);
            }
        }
        return goblinFrontSeckillVo;
    }
    /**
     * 获得商品详情
     */
    public  GoblinFrontGoodDetailVo getGoodsDetail(String spuId){
        GoblinFrontGoodDetailVo goblinFrontGoodDetailVo=GoblinFrontGoodDetailVo.getNew();
        GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(spuId);
        goblinFrontGoodDetailVo.setGoblinGoodsInfoVo(goblinGoodsInfoVo);
        //skuIdList
        if(null!=goblinGoodsInfoVo){
            List<String> skuIdList=goblinGoodsInfoVo.getSkuIdList();
            ArrayList<GoblinGoodsSkuInfoVo> list=ObjectUtil.getGoblinGoodsSkuInfoVoArrayList();
            for(String sku:skuIdList){
                GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo=goblinRedisUtils.getGoodsSkuInfoVo(sku);
                list.add(goblinGoodsSkuInfoVo);
            }
            goblinFrontGoodDetailVo.setGoblinGoodsSkuInfoVolist(list);
        }
        return  goblinFrontGoodDetailVo;
    }
    /**
     * 获得商品详情
     */
    public  List getMoudleIndex(){
        if(!redisUtil.hasKey(GoblinRedisConst.MOUDLE_INDEX)){
            return null;
        }
        //GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.get(spuId);
        List<GoblinFrontMoudleIndex> list= (List<GoblinFrontMoudleIndex>) redisUtil.get(GoblinRedisConst.MOUDLE_INDEX);
        return  list;
    }
    /***
     * @author zhangfuxin
     * @Description:获取魔方
     * @date 2022/1/10 下午4:49
     */
    public GoblinFrontCubeVo getCube(){
        GoblinFrontCubeVo goblinFrontCubeVo=GoblinFrontCubeVo.getNew();
        ArrayList<GoblinGoodsInfoVo> goblinGoodsInfoVoArrayList= ObjectUtil.getGoblinGoodsInfoVos();
        if(!redisUtil.hasKey(GoblinRedisConst.FRONT_GOBLINFRONTCUBE)){
            return null;
        }
        List<GoblinFrontCube> list= (List<GoblinFrontCube>) redisUtil.get(GoblinRedisConst.FRONT_GOBLINFRONTCUBE);
        if(list.size()>0){
            BeanUtils.copyProperties(list.get(0),goblinFrontCubeVo);
            for(String spuid:goblinFrontCubeVo.getSpuId().split(",")){
                GoblinGoodsInfoVo goblinGoodsInfoVo= goblinRedisUtils.getGoodsInfoVo(spuid);
                if(null!=goblinGoodsInfoVo){
                    GoblinGoodsInfoVo goblinGoodsInfoVo1=GoblinGoodsInfoVo.getNew();
                    BeanUtils.copyProperties(goblinGoodsInfoVo,goblinGoodsInfoVo1);
                    goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo1);
                }
            }
            goblinFrontCubeVo.setGoblinGoodsInfoVoList(goblinGoodsInfoVoArrayList);

        }
        return goblinFrontCubeVo;
    }
    public  GoblinStoreInfoVo getStore(String storId){
        Query query = new Query();
        query.addCriteria(Criteria.where("storeId").is(storId));
        long count = mongoTemplate.count(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        GoblinStoreInfoVo goblinStoreInfoVo=goblinRedisUtils.getStoreInfoVo(storId);
        goblinStoreInfoVo.setCount((int) count);
      return   goblinStoreInfoVo;
    }
    /***
     * @author zhangfuxin
     * @Description:获得商铺分类
     * @date 2022/1/18 下午1:44
     */
    public List<GoblinStoreGoodsCategoryVo> getStoreCategory(String storId){
        //店铺分类数据源
        List<GoblinStoreGoodsCategoryVo> list=goblinRedisUtils.getStoreGoodsCategoryVos(storId);
        return list;
    }
    /**
     * 找到分类
     */
    public GoblinCategoryzfVo getCategory(String categoryId){
        GoblinCategoryzfVo goblinCategoryzfVo=GoblinCategoryzfVo.getNew();
        ArrayList<GoblinSelfGoodsCategoryVo> list1=ObjectUtil.getGoblinSelfGoodsCategoryVoArrayList();
        //先找到   当前的分类id
        GoblinSelfGoodsCategoryVo pa=null;
        //获取到分类
        List<GoblinSelfGoodsCategoryVo> list=goblinRedisUtils.getSelfGoodsCategoryVos();
        for(GoblinSelfGoodsCategoryVo goblinSelfGoodsCategoryVo:list){
            if (categoryId.equals(goblinSelfGoodsCategoryVo.getCateId())) {
                goblinCategoryzfVo.setGoblinSelfGoodsCategoryVo(goblinSelfGoodsCategoryVo);
                pa=goblinSelfGoodsCategoryVo;
            }
        }
        //找到  该分类的子集
        if(null!=pa){
            for(GoblinSelfGoodsCategoryVo goblinSelfGoodsCategoryVo:list){
                if(pa.getCateId().equals(goblinSelfGoodsCategoryVo.getCatePid())){
                    list1.add(goblinSelfGoodsCategoryVo);
                }

            }
        }
        goblinCategoryzfVo.setList(list1);
        return goblinCategoryzfVo;

    }
    public List<GoblinGoodsInfoVo> getStoreGoodes(String storeId,String categoryId){
        //
        Query query = new Query();
        query.addCriteria(Criteria.where("storeId").is(storeId));
        if(StringUtil.isNotBlank(categoryId)){
            query.addCriteria(new Criteria().orOperator(
                    Criteria.where("cateFid").is(categoryId),
                    Criteria.where("cateSid").is(categoryId),
                    Criteria.where("cateTid").is(categoryId)
            ));
        }
        // 查询总数
        List<GoblinGoodsInfoVo> list = mongoTemplate.find(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        if(list.size()>0){
            //找到 销量
            for(GoblinGoodsInfoVo goblinGoodsInfoVo:list){
                Integer counts=goblinRedisUtils.getSpuSaleCount(goblinGoodsInfoVo.getSpuId());
                if(counts==null){
                    goblinGoodsInfoVo.setCount(0);
                }else{
                    goblinGoodsInfoVo.setCount(counts);
                }
            }
            Collections.sort(list, new Comparator<GoblinGoodsInfoVo>() {
                public int compare(GoblinGoodsInfoVo arg0, GoblinGoodsInfoVo arg1) {
                    return -(arg0.getCount().compareTo(arg1.getCount()));
                }});
        }
        return list;
    }

    /**
     *音乐人列表
     */
    public GoblinFrontCategoryListVo getMusic(String tagId,String type,int page,int pageSize){
        //
        Query query = new Query();
        query.addCriteria(new Criteria().orOperator(
                Criteria.where("extagVoList.tagId").is(tagId)
        ));
        Pageable pageable=null;
        //
        boolean isRe=false;
        if(type.equals("1")){
            isRe=true;
        }else if(type.equals("2")){
            pageable = PageRequest.of(page, pageSize, Sort.by(Sort.Direction.DESC, "shelvesAt"));
        }else if(type.equals("3")){
            pageable = PageRequest.of(page, pageSize, Sort.by(Sort.Direction.DESC, "priceGe"));
        }else if(type.equals("4")){
            pageable = PageRequest.of(page, pageSize, Sort.by(Sort.Direction.ASC, "priceGe"));
        }
        // 排序 分页
        // Query query = Query.query(Criteria.where("status").ne(1).and("status").ne(0));

        // 查询总数
        long count = mongoTemplate.count(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        if(!isRe){
            query.with(pageable);
        }
        List<GoblinGoodsInfoVo> list = mongoTemplate.find(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        if(list.size()>0&&isRe){
            //找到 销量
            for(GoblinGoodsInfoVo goblinGoodsInfoVo:list){
                Integer counts=goblinRedisUtils.getSpuSaleCount(goblinGoodsInfoVo.getSpuId());
                if(counts==null){
                    goblinGoodsInfoVo.setCount(0);
                }else{
                    goblinGoodsInfoVo.setCount(counts);
                }
            }
            Collections.sort(list, new Comparator<GoblinGoodsInfoVo>() {
                public int compare(GoblinGoodsInfoVo arg0, GoblinGoodsInfoVo arg1) {
                    return -(arg0.getCount().compareTo(arg1.getCount()));
                }});
        }
        GoblinFrontCategoryListVo goblinFrontCategoryListVo=GoblinFrontCategoryListVo.getNew();
        goblinFrontCategoryListVo.setCount(count);
        goblinFrontCategoryListVo.setSpuList(list);
        return goblinFrontCategoryListVo;
    }

    /**
     * 获取分类列表
     * 1、销量优先、2、新品优先、3、价格降序、4、价格升序
     */
    public GoblinFrontCategoryListVo getCategoryList(String type,String categoryId,int page,int pageSize){
        //
        Query query = new Query();
        query.addCriteria(new Criteria().orOperator(
                Criteria.where("cateSid").is(categoryId),
                Criteria.where("cateTid").is(categoryId)
        ));
        Pageable pageable=null;
        //
        boolean isRe=false;
        if(type.equals("1")){
            isRe=true;
        }else if(type.equals("2")){
             pageable = PageRequest.of(page, pageSize, Sort.by(Sort.Direction.DESC, "shelvesAt"));
        }else if(type.equals("3")){
            pageable = PageRequest.of(page, pageSize, Sort.by(Sort.Direction.DESC, "priceGe"));
        }else if(type.equals("4")){
            pageable = PageRequest.of(page, pageSize, Sort.by(Sort.Direction.ASC, "priceGe"));
        }
        // 排序 分页
       // Query query = Query.query(Criteria.where("status").ne(1).and("status").ne(0));

        // 查询总数
        long count = mongoTemplate.count(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        if(!isRe){
            query.with(pageable);
        }
        List<GoblinGoodsInfoVo> list = mongoTemplate.find(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        if(list.size()>0&&isRe){
            //找到 销量
            for(GoblinGoodsInfoVo goblinGoodsInfoVo:list){
                Integer counts=goblinRedisUtils.getSpuSaleCount(goblinGoodsInfoVo.getSpuId());
                if(counts==null){
                    goblinGoodsInfoVo.setCount(0);
                }else{
                    goblinGoodsInfoVo.setCount(counts);
                }
            }
            Collections.sort(list, new Comparator<GoblinGoodsInfoVo>() {
                public int compare(GoblinGoodsInfoVo arg0, GoblinGoodsInfoVo arg1) {
                    return -(arg0.getCount().compareTo(arg1.getCount()));
                }});
        }
        GoblinFrontCategoryListVo goblinFrontCategoryListVo=GoblinFrontCategoryListVo.getNew();
        goblinFrontCategoryListVo.setCount(count);
        goblinFrontCategoryListVo.setSpuList(list);
        return goblinFrontCategoryListVo;
    }


    /**
     * @author zhangfuxin
     * @Description:精选商品列表
     * @date 2022/1/5 下午3:00
     */
    @Override
    public GoblinFrontSelectGoodVo getSelectGoods(int page, int pageSize) {
        if(!redisUtil.hasKey(GoblinRedisConst.SELECT_GOODS)){
            return null;
        }
        //redis 取出精选商品列表
        List<GoblinFrontSelectGoods> list= (List<GoblinFrontSelectGoods>) redisUtil.get(GoblinRedisConst.SELECT_GOODS);
        if(null!=list&&list.size()==1){
            //获取商品列表
            String spuId=list.get(0).getSpuId();
            int start=page*pageSize;
            int end =start+pageSize;
            String[] ids=spuId.split(",");
            if(end>ids.length){
                end=ids.length;
            }
            //创建
            GoblinFrontSelectGoodVo goblinFrontSelectGoodVo=GoblinFrontSelectGoodVo.getNew();
            goblinFrontSelectGoodVo.setCount(ids.length);
            //
            ArrayList<GoblinGoodsInfoVo> goblinGoodsInfoVoArrayList= ObjectUtil.getGoblinGoodsInfoVos();
            for(int i=0;i<end;i++){
               if (i>=start){
                   GoblinGoodsInfoVo goblinGoodsInfoVo= goblinRedisUtils.getGoodsInfoVo(ids[i]);
                   goblinGoodsInfoVoArrayList.add(goblinGoodsInfoVo);
               }
            }
            goblinFrontSelectGoodVo.setGoblinGoodsInfoVoList(goblinGoodsInfoVoArrayList);
            return goblinFrontSelectGoodVo;
        }
        return null;
    }

    public  boolean belongCalendar( String startString, String  endString) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Date from = simpleDateFormat.parse(startString);
        Date end= simpleDateFormat.parse(endString);
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Calendar after = Calendar.getInstance();
        after.setTime(from);
        Calendar before = Calendar.getInstance();
        before.setTime(end);
        if (date.after(after) && date.before(before)) {
            return true;
        } else {
            return false;
        }
    }
    //判断是否是该时间之后
    public boolean afterCalendar(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Date timefrom = simpleDateFormat.parse(time);
        if (date.after(timefrom)) {
            return true;
        } else {
            return false;
        }
    }
    //判断是否是该时间之后
    public boolean beforeCalendar(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DATE_FULL_STR);//注意月份是MM
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        Date timefrom = simpleDateFormat.parse(time);
        if (date.before(timefrom)) {
            return true;
        } else {
            return false;
        }
    }
    /**
     * @author zhangfuxin
     * @Description:添加购物车
     * @date 2022/1/11 下午4:16
     */
    public boolean addShoopCart(String spuId, String storeId,String skuId,Integer number,String userId){
        if(null==number||number<=0){
            return false;
        }
        boolean isGoods=false;
        String cardId="";
        //判断该用户 redis里是否有购物车
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if(null==goblinShoppingCartVoo){
            //创建 voo
            GoblinShoppingCartVoo goblinShoppingCartVoo1=GoblinShoppingCartVoo.getNew();
            // 根据shop分类
            ArrayList<GoblinShoppingCartVo> list=ObjectUtil.goblinShoppingCartVoArrayList();
            GoblinShoppingCartVo goblinShoppingCartVo=GoblinShoppingCartVo.getNew();
            goblinShoppingCartVo.setStoreId(storeId);
            //该商铺下的所有商品
            ArrayList<GoblinShoppingCartVoDetail> list1=ObjectUtil.goblinShoppingCartVoDetailArrayList();
            //创建 购物车vo
            GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=this.setValue(userId,storeId,spuId,skuId,number);
            list1.add(goblinShoppingCartVoDetail);
            goblinShoppingCartVo.setSkuList(list1);
            list.add(goblinShoppingCartVo);
            goblinShoppingCartVoo1.setShopList(list);
            goblinShoppingCartVoo1.setGoblinShoppingCartId(IDGenerator.nextSnowId());
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo1,userId);
            insertShopCartMysql(goblinShoppingCartVoDetail.getCarId(),spuId,storeId,skuId,1,userId);
        }else{
            //查看是否有该商铺
            List<GoblinShoppingCartVo> list=goblinShoppingCartVoo.getShopList();
            boolean isShop=false;
            for(GoblinShoppingCartVo goblinShoppingCartVo:list){
                if(storeId.equals(goblinShoppingCartVo.getStoreId())){
                    //有这个商铺的 东西
                    List<GoblinShoppingCartVoDetail> list1=goblinShoppingCartVo.getSkuList();
                    //查看是否有这个商品

                    for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:list1){
                        if(skuId.equals(goblinShoppingCartVoDetail.getSkuId())){
                            isGoods=true;
                            goblinShoppingCartVoDetail.setNumber((goblinShoppingCartVoDetail.getNumber()+number));
                            cardId=goblinShoppingCartVoDetail.getCarId();
                        }
                    }
                    if(isGoods){
                        //添加商品 数量
                        //不需要做
                    }else{
                        //创建商品放入到list
                        GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=this.setValue(userId,storeId,spuId,skuId,number);
                        cardId=goblinShoppingCartVoDetail.getCarId();
                        list1.add(goblinShoppingCartVoDetail);
                    }
                    isShop=true;
                }
            }
            if(!isShop){
                GoblinShoppingCartVo goblinShoppingCartVo=GoblinShoppingCartVo.getNew();
                goblinShoppingCartVo.setStoreId(storeId);
                //该商铺下的所有商品
                ArrayList<GoblinShoppingCartVoDetail> list1=ObjectUtil.goblinShoppingCartVoDetailArrayList();
                //创建 购物车vo
                GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=this.setValue(userId,storeId,spuId,skuId,1);
                list1.add(goblinShoppingCartVoDetail);
                goblinShoppingCartVo.setSkuList(list1);
                list.add(goblinShoppingCartVo);
            }
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
            if(isGoods){
                updateShopCartMysql(cardId,number,userId);
            }else{
                insertShopCartMysql(cardId,spuId,storeId,skuId,number,userId);
            }
        }
        return true;
    }
    /***
     * @author zhangfuxin
     * @Description: 修改 购物车里 数量
     * @date 2022/1/11 下午6:24
     */
    public  boolean updateShopCart(String spuId, String storeId,String skuId,Integer number,String userId){
        if(null==number||number<=0){
                return false;
        }
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        String cardId="";
        if(null!=goblinShoppingCartVoo){
            List<GoblinShoppingCartVo>  list=goblinShoppingCartVoo.getShopList();
            //遍历商铺
            for(GoblinShoppingCartVo goblinShoppingCartVo:list){
                if(storeId.equals(goblinShoppingCartVo.getStoreId())){
                    //找到 商品id
                    List<GoblinShoppingCartVoDetail> list1=goblinShoppingCartVo.getSkuList();
                    for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:list1){
                        if(skuId.equals(goblinShoppingCartVoDetail.getSkuId())){
                            cardId=goblinShoppingCartVoDetail.getCarId();
                            goblinShoppingCartVoDetail.setNumber(number);
                        }
                    }
                }
            }
            //调用储存方法
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
            updateShopCartMysql(cardId,number,userId);
        }
        return true;
    }

    public int getShopCartCount(String userId){
        log.info("获取商品数量{}",userId);
        int  count=0;
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if(null!=goblinShoppingCartVoo){
            List<GoblinShoppingCartVo> shopList=goblinShoppingCartVoo.getShopList();
            for(GoblinShoppingCartVo goblinShoppingCartVo:shopList){
                List<GoblinShoppingCartVoDetail> skuList=goblinShoppingCartVo.getSkuList();
                for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:skuList){
                    count=goblinShoppingCartVoDetail.getNumber()+count;
                }
            }
        }
        return count;
    }
    /***
     * @author zhangfuxin
     * @Description:存储信息
     * @date 2022/1/17 下午4:55
     */
    public boolean saveDate(String data,String userId) {
        redisUtil.set(GoblinRedisConst.FRONT_SHOPCART_TWO.concat(userId),data,60*60*24);
        return true;
    }
    public String getDate(String userId) {
        if(redisUtil.get(GoblinRedisConst.FRONT_SHOPCART_TWO.concat(userId))==null){
            return "";
        }
        return (String) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART_TWO.concat(userId));
    }
    /**
     * 删除购物车里面的商品
     */
    public boolean delteShoppingCart(String[] skuIds,String userId) {
        boolean isDeleteAll = false;
        GoblinShoppingCartVoo goblinShoppingCartVoo = (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if (null != goblinShoppingCartVoo) {
            List<GoblinShoppingCartVo> shopList = goblinShoppingCartVoo.getShopList();

            Iterator<GoblinShoppingCartVo> shopIter = shopList.iterator();
            while (shopIter.hasNext()){
                GoblinShoppingCartVo goblinShoppingCartVo=shopIter.next();
                List<GoblinShoppingCartVoDetail> skuList = goblinShoppingCartVo.getSkuList();
                Iterator<GoblinShoppingCartVoDetail> iterator = skuList.iterator();
                while(iterator.hasNext()){
                    GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=iterator.next();
                    for (String skuId : skuIds) {
                        if (goblinShoppingCartVoDetail.getSkuId().equals(skuId)) {
                            //skuList.remove(goblinShoppingCartVoDetail);
                            iterator.remove();
                        }
                    }
                }
                if(skuList.size()==0){
                    shopIter.remove();
                }
            }
            if(shopList.size()==0){
                deleteRedisMongodbMysqlShop(goblinShoppingCartVoo,userId,skuIds);
                deleteMysql(userId,skuIds);
            }else{
                saveRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
                deleteMysql(userId,skuIds);
            }
        }

       /* if(this.getShopCartCount(userId)==0){
            //删除redis、删除mongodb
            deleteRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
        }else{
            saveRedisMongodbMysqlShop(goblinShoppingCartVoo,userId);
        }
*/
    return true;
    }
    /**
     * @author zhangfuxin
     * @Description: 获得购物车列表
     * @date 2022/1/12 下午2:36
     */
    public GoblinShoppingCartVoo getShoppCart(String userId){
        //判断该用户 redis里是否有购物车
        GoblinShoppingCartVoo goblinShoppingCartVoo= (GoblinShoppingCartVoo) redisUtil.get(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        if(null==goblinShoppingCartVoo){
            return null;
        }
        //遍历里面信息
        for(GoblinShoppingCartVo goblinShoppingCartVo:goblinShoppingCartVoo.getShopList()){
            for(GoblinShoppingCartVoDetail goblinShoppingCartVoDetail:goblinShoppingCartVo.getSkuList()){
                //找到对应的  spu  和 sku
                GoblinGoodsInfoVo goblinGoodsInfoVo=goblinRedisUtils.getGoodsInfoVo(goblinShoppingCartVoDetail.getSpuId());
                GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo=goblinRedisUtils.getGoodsSkuInfoVo(goblinShoppingCartVoDetail.getSkuId());
                goblinShoppingCartVoDetail.setGoblinGoodsInfoVo(goblinGoodsInfoVo);
                goblinShoppingCartVoDetail.setGoblinGoodsSkuInfoVo(goblinGoodsSkuInfoVo);
            }
        }
        goblinShoppingCartVoo.setShoopingCount(this.getShopCartCount(userId));
        return goblinShoppingCartVoo;
    }
    public GoblinShoppingCartVoDetail setValue(String userId,String storeId,String spuId,String skuId,Integer number){
        GoblinShoppingCartVoDetail goblinShoppingCartVoDetail=GoblinShoppingCartVoDetail.getNew();
        goblinShoppingCartVoDetail.setCarId(IDGenerator.nextSnowId());
        goblinShoppingCartVoDetail.setUserId(userId);
        goblinShoppingCartVoDetail.setStoreId(storeId);
        goblinShoppingCartVoDetail.setSpuId(spuId);
        goblinShoppingCartVoDetail.setSkuId(skuId);
        goblinShoppingCartVoDetail.setNumber(number);
        goblinShoppingCartVoDetail.setDelTag(0);
        goblinShoppingCartVoDetail.setCreatedAt(LocalDateTime.now());
        goblinShoppingCartVoDetail.setUpdatedAt(LocalDateTime.now());
        return goblinShoppingCartVoDetail;
    }
    public void saveRedisMongodbMysqlShop(GoblinShoppingCartVoo goblinShoppingCartVoo,String userId){
        goblinShoppingCartVoo.setUserId(userId);
        //redis存储
        redisUtil.set(GoblinRedisConst.FRONT_SHOPCART.concat(userId),goblinShoppingCartVoo);
        //mongodb存储
        boolean exists2  =mongoTemplate.exists(Query.query(Criteria.where("goblinShoppingCartId").is(goblinShoppingCartVoo.getGoblinShoppingCartId())),GoblinShoppingCartVoo.class, GoblinShoppingCartVoo.class.getSimpleName());
        if(exists2){
            BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinShoppingCartVoo)));
            mongoTemplate.getCollection(GoblinShoppingCartVoo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("goblinShoppingCartId").is(goblinShoppingCartVoo.getGoblinShoppingCartId())).getQueryObject(),
                    orderObject
            );
        }else{
            mongoTemplate.save(goblinShoppingCartVoo,GoblinShoppingCartVoo.class.getSimpleName());
        }
        //mysql 消息队列
    }
    //删除redis 删除mongodb
    public void deleteRedisMongodbMysqlShop(GoblinShoppingCartVoo goblinShoppingCartVoo,String userId,String[] skuIds){
        //redis存储
        redisUtil.del(GoblinRedisConst.FRONT_SHOPCART.concat(userId));
        //mongodb 删除
        mongoTemplate.remove(Query.query(Criteria.where("goblinShoppingCartId").is(goblinShoppingCartVoo.getGoblinShoppingCartId())), GoblinShoppingCartVoo.class, GoblinShoppingCartVoo.class.getSimpleName());
        //mysql  删除  按照 userid 、skuid
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("goblin_shop.cart.delete"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        for(String sku:skuIds){
            sqlData.add(new Object[]{
               userId,sku,0
            });
        }
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        log.info("sql信息{}",sqlDatas);
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getKey(), sqlDatas);
        log.info("发送购物车消息队列完毕");
    }
    public void insertShopCartMysql(String carId ,String spuId, String storeId,String skuId,Integer number,String userId){
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("goblin_shop.cart.insert"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
               //car_id, user_id, store_id,spu_id, sku_id, `number`,marketing_id, del_tag, `comment`
                carId,userId,storeId,spuId,skuId,1,"",0,""
        });
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getKey(), sqlDatas);
        log.info("发送购物车消息队列完毕");
    }
    public void updateShopCartMysql(String carId ,Integer number,String userId){
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("goblin_shop.cart.update"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        sqlData.add(new Object[]{
                //update goblin_shopping_cart set `number` = ? where car_id=? and user_id=?
                number,carId,userId
        });
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getKey(), sqlDatas);
        log.info("发送购物车消息队列完毕");
    }

    //删除
    public void deleteMysql(String userId,String[] skuIds){
        //mysql  删除  按照 userid 、skuid
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        sqls.add(SqlMapping.get("goblin_shop.cart.delete"));
        LinkedList<Object[]> sqlData = CollectionUtil.linkedListObjectArr();
        for(String sku:skuIds){
            sqlData.add(new Object[]{
                    1,userId,sku
            });
        }
        String sqlDatas = SqlMapping.gets(sqls, sqlData);
        log.info(sqlDatas);
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_SHOP_CART.getKey(), sqlDatas);
        log.info("发送购物车消息队列完毕");
    }


}
