package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontCubeService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontCube;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.mapper.GoblinFrontCubeMapper;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import com.liquidnet.service.goblin.param.GoblinFrontCubeParam;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-07
 */
@Service
public class GoblinFrontCubeServiceImpl extends ServiceImpl<GoblinFrontCubeMapper, GoblinFrontCube> implements IGoblinFrontCubeService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    GoblinFrontCubeMapper goblinFrontCubeMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    GoblinGoodsMapper goblinGoodsMapper;

    public boolean create(GoblinFrontCube goblinFrontCube){
        goblinFrontCube.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontCube.setCubeId(IDGenerator.nextSnowId());
        //增加 banner
        goblinFrontCubeMapper.insert(goblinFrontCube);
        return true;
    }
    public boolean deleteGoblinFrontCube(Long id){
        GoblinFrontCube goblinFrontCube=goblinFrontCubeMapper.selectById(id);
        goblinFrontCube.setDelTag(1);
        goblinFrontCube.setUpdateTime(LocalDateTime.now());
        //数据库修改
        goblinFrontCubeMapper.updateById(goblinFrontCube);
        return true;
    }

    public boolean updateOrCreate(List<GoblinFrontCube> list) {
        for(GoblinFrontCube goblinFrontCube:list){
            if (goblinFrontCube.getMid() == 0) {
                this.create(goblinFrontCube);
            } else {
                goblinFrontCube.setUpdateTime(LocalDateTime.now());
                //数据库修改
                goblinFrontCubeMapper.updateById(goblinFrontCube);
            }
        }
        return true;
    }
    public List<GoblinFrontCubeParam> listGoblinFrontCubeParam(){
        LambdaQueryWrapper<GoblinFrontCube> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCube.class);
        queryWrapper.ne(GoblinFrontCube::getDelTag,1);
        List<GoblinFrontCube> list=goblinFrontCubeMapper.selectList(queryWrapper);
        List<GoblinFrontCubeParam> list1=new ArrayList<>();
        for(GoblinFrontCube goblinFrontCube:list){
            String[] spuIds=goblinFrontCube.getSpuId().split(",");
            for(String supid:spuIds){
                //找到  spu详情
                LambdaQueryWrapper<GoblinGoods> queryWrappers = Wrappers.lambdaQuery(GoblinGoods.class);
                queryWrappers.ne(GoblinGoods::getDelFlg,"1");
                queryWrappers.eq(GoblinGoods::getSpuId,supid);
                List<GoblinGoods> goodsList= goblinGoodsMapper.selectList(queryWrappers);
                GoblinFrontCubeParam goblinFrontCubeParam=new GoblinFrontCubeParam();
                BeanUtils.copyProperties(goblinFrontCube,goblinFrontCubeParam);
                goblinFrontCubeParam.setGoblinGoods(goodsList.get(0));
                list1.add(goblinFrontCubeParam);
            }
        }
        return list1;
    }
    public boolean online(){
        LambdaQueryWrapper<GoblinFrontCube> queryWrapper = Wrappers.lambdaQuery(GoblinFrontCube.class);
        queryWrapper.ne(GoblinFrontCube::getDelTag,1);
        List<GoblinFrontCube> list=goblinFrontCubeMapper.selectList(queryWrapper);
        if(list.size()>0){
            //mongodb
            for(GoblinFrontCube goblinFrontCube: list){
                GoblinFrontCube goblinFrontCube1=mongoTemplate.findOne(Query.query(Criteria.where("cubeId").is(goblinFrontCube.getCubeId())), GoblinFrontCube.class, GoblinFrontCube.class.getSimpleName());
                if(null==goblinFrontCube1){
                    mongoTemplate.save(goblinFrontCube,GoblinFrontCube.class.getSimpleName());
                }else{
                    BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontCube)));
                    mongoTemplate.getCollection(GoblinFrontCube.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("cubeId").is(goblinFrontCube.getCubeId())).getQueryObject(),
                            orderObject
                    );
                }
            }
            //redis
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.FRONT_GOBLINFRONTCUBE,list);
        }

        return true;
    }


}
