package com.liquidnet.service.sweet.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@ApiModel(value = "SweetDouDouCheckParam", description = "入参")
@Data
public class SweetDouDouCheckParam implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(position = 1, required = true, value = "核验人手机号", example = "10000000000")
    @NotBlank(message = "authMobile不能为空")
    private String authMobile;

    @ApiModelProperty(position = 2, required = true, value = "doudouId", example = "5223713433667502081163230")
    @NotBlank(message = "doudouId不能为空")
    private String doudouId;

    @ApiModelProperty(position = 3, required = true, value = "用户ID", example = "937724050260131847782985")
    @NotBlank(message = "userId不能为空")
    private String userId;
}
