package com.liquidnet.common.third.zxlnft.service;

import com.liquidnet.common.third.zxlnft.dto.nft.*;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlnftSdkService
 * @Package com.liquidnet.common.third.zxlnft.service
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/17 15:53
 */
public interface ZxlnftSdkService {
    /**
     * 1.下发注册实名验证码接口
     * @param req
     * @return
     */
    Nft001RegisterVerifyCodeResp nft001RegisterVerifyCode(Nft001RegisterVerifyCodeReq req);

    /**
     * 2.自然人注册实名接口
     * @param req
     * @return
     */
    Nft002RegisterPersonResp nft002RegisterPerson(Nft002RegisterPersonReq req);

    /**
     * 3.自然人注册实名（使用nft平台签名)接口
     * @param req
     * @return
     */
    Nft003RegisterPersonPlatformResp nft003RegisterPersonPlatform(Nft003RegisterPersonPlatformReq req);

    /**
     * 4.营业执照上传接口
     * @param req
     * @return
     */
    Nft004BusinessLicenseUploadResp nft004BusinessLicenseUpload(Nft004BusinessLicenseUploadReq req);

    /**
     * 5.营业执照上传（使用nft平台签名）接口
     * @param req
     * @return
     */
    Nft005BusinessLicenseUploadPlatformResp nft005BusinessLicenseUploadPlatform(Nft005BusinessLicenseUploadPlatformReq req);

    /**
     * 6.电子公函上传接口
     * @param req
     * @return
     */
    Nft006OfficialLetterUploadResp nft006OfficialLetterUpload(Nft006OfficialLetterUploadReq req);

    /**
     * 7.电子公函上传（使用nft平台签名）接口
     * @param req
     * @return
     */
    Nft007OfficialLetterUploadPlatformResp nft007OfficialLetterUploadPlatform(Nft007OfficialLetterUploadPlatformReq req);

    /**
     * 8.图片内容检测
     * @param req
     * @return
     */
    Nft008QueryImageModerationResp nft008QueryImageModeration(Nft008QueryImageModerationReq req);

    /**
     * 9.企业注册实名接口
     * @param req
     * @return
     */
    Nft009RegisterCompanyResp nft009RegisterCompany(Nft009RegisterCompanyReq req);

    /**
     * 10.企业注册实名（使用nft平台签名）接口
     * @param req
     * @return
     */
    Nft010RegisterCompanyPlatformResp nft010RegisterCompanyPlatform(Nft010RegisterCompanyPlatformReq req);

    /**
     * 11.下发查询用户信息验证码接
     * @param req
     * @return
     */
    Nft011UserQueryVerifyCodeResp nft011UserQueryVerifyCode(Nft011UserQueryVerifyCodeReq req);

    /**
     * 12.查询用户信息接口
     * @param req
     * @return
     */
    Nft012UserQueryResp nft012UserQuery(Nft012UserQueryReq req);

    /**
     * 13.NFT地址绑定接口
     * @param req
     * @return
     */
    Nft013IdentityBindSubmitResp nft013IdentityBindSubmit(Nft013IdentityBindSubmitReq req);

    /**
     * 14.受信平台NFT身份绑定接口
     * @param req
     * @return
     */
    Nft014IdentityBindSubmitByTrustedResp nft014IdentityBindSubmitByTrusted(Nft014IdentityBindSubmitByTrustedReq req);

    /**
     * 15.NFT平台自身身份绑定，
     * @param req
     * @return
     */
    Nft015IdentityBindPlatformSelfResp nft015IdentityBindPlatformSelf(Nft015IdentityBindPlatformSelfReq req);

    /**
     * 16.绑定状态批量查询接口
     * @param req
     * @return
     */
    Nft016IdentityBindQueryResp nft016IdentityBindQuery(Nft016IdentityBindQueryReq req);

    /**
     * 17.地址与身份对应关系核验接
     * @param req
     * @return
     */
    Nft017IdentityVerifyIdentityResp nft017IdentityVerifyIdentity(Nft017IdentityVerifyIdentityReq req);

    /**
     * 18.请求人脸核身h5url
     * @param req
     * @return
     */
    Nft018FaceUrlResp nft018FaceUrl(Nft018FaceUrlReq req);

    /**
     * 19.通过用户地址请求人脸核身h5url
     * @param req
     * @return
     */
    Nft019FaceUrlByAddressResp nft019FaceUrlByAddress(Nft019FaceUrlByAddressReq req);

    /**
     * 20.人身核对结果查询接口
     * @param req
     * @return
     */
    Nft020FaceQueryResp nft020FaceQuery(Nft020FaceQueryReq req);

    /**
     * 21.查询素材地址接口
     * @param req
     * @return
     */
    Nft021UploadUrlResp nft021UploadUrl(Nft021UploadUrlReq req);

    /**
     * 22.生成素材上传临时密钥接口
     * @param req
     * @return
     */
    Nft022UploadSecretResp nft022UploadSecret(Nft022UploadSecretReq req);

    /**
     * 23.申请积分
     * @param req
     * @return
     */
    Nft023PointApplyResp nft023PointApply(Nft023PointApplyReq req);

    /**
     * 24.查询积分申请结果
     * @param req
     * @return
     */
    Nft024PointApplyResultResp nft024PointApplyResult(Nft024PointApplyResultReq req);

    /**
     * 25.平台积分转移
     * @param req
     * @return
     */
    Nft025PointTransferResp nft025PointTransfer(Nft025PointTransferReq req);

    /**
     * 26.平台积分转移状态查询
     * @param req
     * @return
     */
    Nft026PointTransferResultResp nft026PointTransferResult(Nft026PointTransferResultReq req);

    /**
     * 27.积分销毁
     * @param req
     * @return
     */
    Nft027PointDestroyResp nft027PointDestroy(Nft027PointDestroyReq req);

    /**
     * 28.查询积分销毁结果
     * @param req
     * @return
     */
    Nft028PointDestoryResultResp nft028PointDestoryResult(Nft028PointDestoryResultReq req);

    /**
     * 29.积分查询
     * @param req
     * @return
     */
    Nft029PointQueryResp nft029PointQuery(Nft029PointQueryReq req);

    /**
     * 30.NFT 系列声明
     * @param req
     * @return
     */
    Nft030SeriesClaimResp nft030SeriesClaim(Nft030SeriesClaimReq req);

    /**
     * 31.查询NFT系列声明结果
     * @param req
     * @return
     */
    Nft031SeriesClaimResultResp nft031SeriesClaimResult(Nft031SeriesClaimResultReq req);

    /**
     * 32.查询系列信息
     * @param req
     * @return
     */
    Nft032SeriesResp nft032Series(Nft032SeriesReq req);

    /**
     * 33.查询该账户资产归属的系列列表
     * @param req
     * @return
     */
    Nft033SeriesListResp nft033SeriesList(Nft033SeriesListReq req);

    /**
     * 34.发行 NFT
     * @param req
     * @return
     */
    Nft034PublishResp nft034Publish(Nft034PublishReq req);

    /**
     * 35.查询 NFT发行结果
     * @param req
     * @return
     */
    Nft035PublishResultResp nft035PublishResult(Nft035PublishResultReq req);

    /**
     * 36.NFT元信息查询
     * @param req
     * @return
     */
    Nft036InfoResp nft036Info(Nft036InfoReq req);

    /**
     * 37.查询账户NFT列表
     * @param req
     * @return
     */
    Nft037AddressListResp nft037AddressList(Nft037AddressListReq req);

    /**
     * 38.查询无系列NFT列表
     * @param req
     * @return
     */
    Nft038AddressWithoutSeriesListResp nft038AddressWithoutSeriesList(Nft038AddressWithoutSeriesListReq req);

    /**
     * 39.查询NFT交易信息列表
     * @param req
     * @return
     */
    Nft039TradeListResp nft039TradeList(Nft039TradeListReq req);

    /**
     * 40.查询转入NFT交易信息列表
     * @param req
     * @return
     */
    Nft040TradeInListResp nft040TradeInList(Nft040TradeInListReq req);

    /**
     * 41.查询转出NFT交易信息列表
     * @param req
     * @return
     */
    Nft041TradeOutListResp nft041TradeOutList(Nft041TradeOutListReq req);

    /**
     * 42.通过地址查询全部NFT交易信息列表
     * @param req
     * @return
     */
    Nft042TradeAllListResp nft042TradeAllList(Nft042TradeAllListReq req);

    /**
     * 43.NFT 购买
     * @param req
     * @return
     */
    Nft043BuyResp nft043Buy(Nft043BuyReq req);

    /**
     * 44.查询 NFT 购买结果
     * @param req
     * @return
     */
    Nft044BuyResultResp nft044BuyResult(Nft044BuyResultReq req);

    /**
     * 45.查询nft购买支付结果
     * @param req
     * @return
     */
    Nft045BuyPayResultResp nft045BuyPayResult(Nft045BuyPayResultReq req);

    /**
     * 46.NFT 转移
     * @param req
     * @return
     */
    Nft046TransferResp nft046Transfer(Nft046TransferReq req);

    /**
     * 46.NFT 转移 v2
     * @param req
     * @return
     */
    Nft046TransferResp nft046TransferV2(Nft046TransferReq req);

    /**
     * 47.NFT 同名转移
     * @param req
     * @return
     */
    Nft047SelfTransferResp nft047SelfTransfer(Nft047SelfTransferReq req);

    /**
     * 48.NFT 批量转移
     * @param req
     * @return
     */
    Nft048BatchTransferResp nft048BatchTransfer(Nft048BatchTransferReq req);

    /**
     * 49.NFT转移状态查询
     * @param req
     * @return
     */
    Nft049TransferResultResp nft049TransferResult(Nft049TransferResultReq req);

    /**
     * 50.NFT销售状态变更
     * @param req
     * @return
     */
    Nft050StatusUpdateResp nft050StatusUpdate(Nft050StatusUpdateReq req);

    /**
     * 51.NFT销售状态变更查询
     * @param req
     * @return
     */
    Nft051StatusUpdateResultResp nft051StatusUpdateResult(Nft051StatusUpdateResultReq req);

    /**
     * 52.NFT售价变更
     * @param req
     * @return
     */
    Nft052PriceUpdateResp nft052PriceUpdate(Nft052PriceUpdateReq req);

    /**
     * 53.NFT 售价变更状态查询
     * @param req
     * @return
     */
    Nft053PriceUpdateResultResp nft053PriceUpdateResult(Nft053PriceUpdateResultReq req);


    /**
     * 54.检查地址是否属于同一个用户主体接口
     * @param req
     * @return
     */
    Nft054QueryUserAddressBelongToUserResp nft054QueryUserAddressBelongToUser(Nft054QueryUserAddressBelongToUserReq req);
}
