-- 20250604 doudou预约签名CD记录表
drop TABLE if exists `sweet_doudou`;
CREATE TABLE `sweet_doudou`
(
    `mid`        bigint unsigned NOT NULL AUTO_INCREMENT,
    `doudou_id`  varchar(255) NOT NULL DEFAULT '' COMMENT 'doudou_id',
    `user_id`    varchar(255) NOT NULL DEFAULT '' COMMENT 'user_id',
    `username`   varchar(255) NOT NULL DEFAULT '' COMMENT '观演人姓名',
    `phone`      varchar(11)  NOT NULL DEFAULT '' COMMENT '观演人手机号',
    `platform`   varchar(100) NOT NULL DEFAULT '' COMMENT  '购买平台',
    `order_code` varchar(100) NOT NULL DEFAULT '' COMMENT  '购买订单号',
    `mark`       varchar(512) NOT NULL DEFAULT '' COMMENT  '想给doudou说的话',
    `status`     tinyint      NOT NULL DEFAULT 1 COMMENT '状态 1已登记 2未中签 3已中签 4已核销',
    `created_at` datetime NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at` datetime NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`),
    KEY          `sweet_doudou_id` (`doudou_id`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'doudou预约签名CD记录表';

-- 20250604 doudou预约签名核验权限表
drop TABLE if exists `sweet_doudou_scope`;
CREATE TABLE `sweet_doudou_scope`
(
    `mid`        bigint unsigned NOT NULL AUTO_INCREMENT,
    `mobile`     varchar(50) NOT NULL COMMENT '核验人手机号',
    `nick_name`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '昵称',
    `real_name`  varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '真实姓名',
    `id_card`    varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '身份证号码',
    `status`     tinyint      NOT NULL DEFAULT 1 COMMENT '状态 0 不可用 1可用',
    `created_at` datetime NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `updated_at` datetime NULL     DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`mid`)
) ENGINE = InnoDB
  DEFAULT CHARSET utf8mb4
  COLLATE utf8mb4_unicode_ci
  ROW_FORMAT = DYNAMIC COMMENT 'doudou预约签名核验权限表';