package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * <p>
 * OSS上传 模型
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PlatformOssFiles implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    private String ossFilesId;
    private String fileName;
    private String ossPath;
    private String contentType;
    private Integer size;
    private String md5str;
    private Integer buckType;
    private String uploaderUid;
    private String uploaderName;

    /**
     * 创建时间
     */
    private String createdAt;

    /**
     * 修改时间
     */
    private String updatedAt;

    private static final PlatformOssFiles obj = new PlatformOssFiles();
    public static PlatformOssFiles getNew() {
        try {
            return (PlatformOssFiles) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new PlatformOssFiles();
        }
    }
}
