package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel
@Data
public class GoblinStoreMarketVo implements Cloneable {
    @ApiModelProperty(value = " 商铺营销表id")
    private String storeMarketId;
    @ApiModelProperty(value = " 营销名称")
    private String name;
    @ApiModelProperty(value = " 营销类型[1-满赠|2-限时秒杀]")
    private Integer type;
    @ApiModelProperty(value = " 活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]")
    private Integer status;
    @ApiModelProperty(value = " 商铺id")
    private String storeId;
    @ApiModelProperty(value = " 营销描述")
    private String describes;
    @ApiModelProperty(value = " 营销开始时间")
    private String startTime;
    @ApiModelProperty(value = " 营销结束时间营销为定金预售的时候，该时间也是第二阶段付款的时间营销为全款预售的时候，该时间也是发货时间")
    private String endTime;
    @ApiModelProperty(value = "活动是否预热[0-否|1-是]")
    private Integer isPre;
    @ApiModelProperty(value = " 活动预热时间")
    private String preTime;
    @ApiModelProperty(value = " 创建时间")
    private String createdAt;

    private static final GoblinStoreMarketVo obj = new GoblinStoreMarketVo();

    public static GoblinStoreMarketVo getNew() {
        try {
            return (GoblinStoreMarketVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMarketVo();
        }
    }
}
