package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetPerformanceShow implements Serializable,Cloneable{
    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 主键id
     */
    private String arId;

    private String arName;

    private String performanceId;
    /**
     * 演出名
     */
    private String performanceName;
    /**
     * 图片地址1
     */
    private String picOne;
    /**
     * 图片地址2
     */
    private String picTwo;
    /**
     * AR地址
     */
    private String arUrl;

    /**
     * 文件大小
     */
    private String fileSize;

    /**
     * 离线地址
     */
    private String offlineUrl;

    /**
     * 状态 1可用 0不可用
     */
    private Integer status;
    /**
     * 开始时间
     */
    private LocalDateTime timeStart;
    /**
     * 结束时间
     */
    private LocalDateTime timeEnd;

    private static final SweetPerformanceShow obj = new SweetPerformanceShow();
    public static SweetPerformanceShow getNew() {
        try {
            return (SweetPerformanceShow) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetPerformanceShow();
        }
    }
}
