package com.liquidnet.service.dragon.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 支付订单日志表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class DragonOrderLogs implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 订单id
     */
    private String code;

    /**
     * 支付类型
     */
    private String paymentType;

    /**
     * 支付通知内容
     */
    private String content;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 删除时间
     */
    private LocalDateTime deletedAt;


}
