package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 轮播图
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinFrontBanner implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long mid;

    /**
     * 图片路径
     */
    private String picUrl;

    /**
     * 排序
     */
    private Integer indexs;

    /**
     * 1、票务2、H5
     */
    private String jumpType;

    /**
     * 开启时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 票务名字
     */
    private String ticketName;
    /***
     * @author zhangfuxin
     * @Description:票务id
     * @date 2022/1/10 下午3:01
     */
    private String ticketId;

    /**
     * 1、首页顶部位置2、首页中部位置
     */
    private Integer bannerType;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    /**
     * bannerId
     */
    private String bannerId;

    /**
     * 0未删除1已删除
     */
    private Integer delTag;


}
