package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class SyncOrderParam implements Cloneable {
    @ApiModelProperty(value = "不用管")
    private String orderId;
    @ApiModelProperty(value = "支付状态[1-成功|0-失败]")
    private Integer status;
    @ApiModelProperty(value = "[写死]HUIFU_PAY_CODE")
    private String code;
    @ApiModelProperty(value = "汇付相关id")
    private String paymentId;
    @ApiModelProperty(value = "[写死]huifu")
    private String paymentType;
    @ApiModelProperty(value = "支付时间")
    private String paymentAt;
    @ApiModelProperty(value = "masterOrderCode")
    private String orderCode;

    @ApiModelProperty(value = "不用管")
    private String type;
    @ApiModelProperty(value = "不用管")
    private String orderCodeId;
    @ApiModelProperty(value = "不用管")
    private BigDecimal price;


    private static final SyncOrderParam obj = new SyncOrderParam();
    public static SyncOrderParam getNew() {
        try {
            return (SyncOrderParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SyncOrderParam();
        }
    }
}
