package com.liquidnet.service.goblin.entity;

import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品规格值
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoodsSpecValue implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 规格id，对应 goblin_goods_spec.spec_id
     */
    private String specId;

    /**
     * 规格值id
     */
    private String specVid;

    /**
     * 规格值的名称
     */
    private String specVname;

    /**
     * 排序，数值越小排序越前
     */
    private Integer specVsort;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    private String comment;


}
