package com.liquidnet.service.sweet.utils;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.SweetManualAppletTFCDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2TFCDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListTFCDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistStageListTFCDto;
import com.liquidnet.service.sweet.entity.SweetManualNotifyTfc;
import com.liquidnet.service.sweet.entity.SweetManualShopTfc;
import com.liquidnet.service.sweet.entity.SweetManualSortTfc;
import com.liquidnet.service.sweet.entity.SweetRichtextTfc;
import com.liquidnet.service.sweet.mapper.*;
import com.liquidnet.service.sweet.vo.SweetArtistsRelationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.*;

@Component
public class RedisTFCDataUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private SweetManualTfcMapper sweetManualTFCMapper;
    @Autowired
    private SweetManualArtistsTfcMapper sweetManualArtistsTFCMapper;
    @Autowired
    private SweetRichtextTfcMapper sweetRichtextTFCMapper;
    @Autowired
    private SweetManualSortTfcMapper sweetManualSortTFCMapper;
    @Autowired
    private SweetManualNotifyTfcMapper sweetManualNotifyTFCMapper;
    @Autowired
    private SweetManualShopTfcMapper sweetManualShopTFCMapper;


    public List<SweetManualAppletTFCDto> setPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_PUSH_LIST;
        List<SweetManualAppletTFCDto> data = sweetManualTFCMapper.getManualAppletDto();
        for (SweetManualAppletTFCDto item : data) {
            if(!item.getIsMember().equals(1)){
                item.setTimeSell(DateUtil.format(DateUtil.addMin(DateUtil.parse(item.getTimeSell(),"yyyy-MM-dd HH:mm:ss"),-item.getPayCountdownMinute()),DateUtil.Formatter.yyyyMMddHHmmss));
            }
            item.setFieldName((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "name"));
            item.setCityName((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "city_name"));
            item.setLatitude((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "latitude"));
            item.setLongitude((String) redisUtil.getDB15RedisHGet(KylinRedisConst.FIELDS + ":" + item.getFieldId(), "longitude"));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取电子手册列表 (城市)
    public List<SweetManualAppletTFCDto> getPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_PUSH_LIST;
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setPushList();
        } else {
            return (List<SweetManualAppletTFCDto>) obj;
        }
    }

    //获取电子手册演出详情
    public SweetManualAppletTFCDto getAppletPerformance(String manualId) {
        List<SweetManualAppletTFCDto> data = getPushList();
        SweetManualAppletTFCDto returnData = SweetManualAppletTFCDto.getNew();
        for (SweetManualAppletTFCDto item : data) {
            if (item.getManualId().equalsIgnoreCase(manualId)) {
                returnData = item;
                break;
            }
        }
        return returnData;
    }

    public SweetManualArtistList2TFCDto setTimeList(String manualId, String content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_TIME_LIST.concat(manualId);
        HashMap<String, Object> map = CollectionUtil.mapStringObject();
        map.put("manualId", manualId);
        List<SweetManualArtistListTFCDto> data = sweetManualArtistsTFCMapper.getManualList(map);

        //获取时间
        SweetManualAppletTFCDto sweetManualAppletDto = getAppletPerformance(manualId);
        Date dateEnd = DateUtil.parse(sweetManualAppletDto.getTimeEnd(), DateUtil.DATE_SMALL_STR);
        Date dateStart = DateUtil.parse(sweetManualAppletDto.getTimeStart(), DateUtil.DATE_SMALL_STR);
        int intervalDay = (int) DateUtil.intervalDays(dateStart, dateEnd);
        ArrayList<String> list = CollectionUtil.arrayListString();
        list.add(DateUtil.format(dateStart, DateUtil.Formatter.yyyy_MM_dd));
        for (int i = 0; i < intervalDay; i++) {
            list.add(DateUtil.format(DateUtil.addDay(dateStart, i + 1), DateUtil.Formatter.yyyy_MM_dd));
        }

        //获取舞台
        List<SweetManualArtistStageListTFCDto> stageData = sweetManualArtistsTFCMapper.getStageNameList(map);

        SweetManualArtistList2TFCDto returnData = SweetManualArtistList2TFCDto.getNew();
        returnData.setDate(list);
        returnData.setData(data);
        returnData.setStage(stageData);
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取时间表
    public SweetManualArtistList2TFCDto getTimeList(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_TIME_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTimeList(manualId, null);
        } else {
            return (SweetManualArtistList2TFCDto) obj;
        }
    }

    public SweetRichtextTfc setRichTextRedisData(String manualId, String type, SweetRichtextTfc content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        SweetRichtextTfc sweetRichtext;
        if (content != null) {
            sweetRichtext = content;
        } else {
            sweetRichtext = sweetRichtextTFCMapper.selectOne(Wrappers.lambdaQuery(SweetRichtextTfc.class).eq(SweetRichtextTfc::getManualId, manualId).eq(SweetRichtextTfc::getType, type));
        }
        redisUtil.set(redisKey, sweetRichtext);
        return sweetRichtext;
    }

    //获取富文本详情
    public SweetRichtextTfc getRichTextRedisData(String manualId, String type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setRichTextRedisData(manualId, type, null);
        } else {
            return (SweetRichtextTfc) obj;
        }
    }

    public List<String> setTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_SORT.concat(manualId);
        SweetManualSortTfc data = sweetManualSortTFCMapper.selectOne(Wrappers.lambdaQuery(SweetManualSortTfc.class).eq(SweetManualSortTfc::getManualId, manualId));
        String[] arrays = data.getShowPosition().split(",");
        List<String> returnData = new ArrayList<>();
        for (String item : arrays) {
            returnData.add(item);
//            returnData.add(SweetConstant.ManualPosition.getMessage(item));
        }
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取显示的标签
    public List<String> getTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_SORT.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTagRedisData(manualId);
        } else {
            return (List<String>) obj;
        }
    }

    public List<SweetManualNotifyTfc> setNotifyRedisData(String manualId, List<SweetManualNotifyTfc> content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_NOTIFY_LIST.concat(manualId);
        List<SweetManualNotifyTfc> data;
        if (content != null) {
            data = content;
        } else {
            data = sweetManualNotifyTFCMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyTfc.class).eq(SweetManualNotifyTfc::getManualId, manualId).eq(SweetManualNotifyTfc::getStatus, 1));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取通知
    public List<SweetManualNotifyTfc> getNotifyRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_NOTIFY_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setNotifyRedisData(manualId, null);
        } else {
            return (List<SweetManualNotifyTfc>) obj;
        }
    }

    public void deletePushListRedisData() {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_PUSH_LIST);//列表
    }

    public void deleteTimeListRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_TIME_LIST.concat(manualId));//列表
    }

    public void deleteSortRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_TFC_MANUAL_SORT.concat(manualId));//列表
    }

    public void setArtistsRelationRedisVo(String uid, String artistsId, String manualId, String type) {

        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LocalDateTime now = LocalDateTime.now();

        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        SweetArtistsRelationVo vo = getArtistsRelationRedisVo(uid, manualId);
        vo.setUid(uid);
        if (type.equalsIgnoreCase("sign")) {
            if (vo.getSignList() == null) {
                ArrayList<String> signList = CollectionUtil.arrayListString();
                signList.add(artistsId);
                vo.setSignList(signList);
                sqls.add(SqlMapping.get("sweet_user_relation_TFC.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 2, artistsId, manualId, now
                });
            } else {
                if (vo.getSignList().contains(artistsId)) {
                    vo.getSignList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_TFC.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId,2
                    });
                } else {
                    vo.getSignList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_TFC.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 2, artistsId, manualId, now
                    });
                }
            }
        } else if (type.equalsIgnoreCase("watch")) {
            if (vo.getWatchList() == null) {
                ArrayList<String> watchList = CollectionUtil.arrayListString();
                watchList.add(artistsId);
                vo.setWatchList(watchList);
                sqls.add(SqlMapping.get("sweet_user_relation_TFC.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 1, artistsId, manualId, now
                });
            } else {
                if (vo.getWatchList().contains(artistsId)) {
                    vo.getWatchList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_TFC.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId,1
                    });
                } else {
                    vo.getWatchList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_TFC.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 1, artistsId, manualId, now
                    });
                }
            }
        }
        redisUtil.set(redisKey, vo);

        queueUtils.sendMsgByRedis(MQConst.SweetQueue.ARTISTS_RELATION.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));
    }

    //获取 签售
    //获取 想看
    public SweetArtistsRelationVo getArtistsRelationRedisVo(String uid, String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return SweetArtistsRelationVo.getNew();
        } else {
            return (SweetArtistsRelationVo) obj;
        }
    }

    //获取 商铺
    public List<SweetManualShopTfc> setManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_SHOP.concat(manualId);
        List<SweetManualShopTfc> list = sweetManualShopTFCMapper.selectList(Wrappers.lambdaQuery(SweetManualShopTfc.class).eq(SweetManualShopTfc::getManualId, manualId).orderBy(true, false, SweetManualShopTfc::getSort));
        redisUtil.set(redisKey, list);
        return list;
    }

    public List<SweetManualShopTfc> getManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_SHOP.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setManualShopRedisData(manualId);
        } else {
            return (List<SweetManualShopTfc>) obj;
        }
    }

//    // 艺人详情
//    public SweetArtists setArtistsDetails(String artistsId) {
//        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_ARTISTS_DETAILS.concat(artistsId);
//        SweetArtists sweetArtists = sweetArtistsMapper.selectOne(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId).eq(SweetArtists::getStatus, 1));
//        redisUtil.set(redisKey, sweetArtists);
//        return sweetArtists;
//    }
//
//    public SweetArtists getArtistsDetails(String artistsId) {
//        String redisKey = SweetConstant.REDIS_KEY_SWEET_TFC_ARTISTS_DETAILS.concat(artistsId);
//        Object obj = redisUtil.get(redisKey);
//        if (obj == null) {
//            return setArtistsDetails(artistsId);
//        } else {
//            return (SweetArtists) obj;
//        }
//    }
}
