package com.liquidnet.service.kylin.dto.param.ticketSystem;

import com.liquidnet.service.kylin.dto.vo.ticketSystem.TimesVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "STInsertPerformanceParam",description = "详情")
public class STInsertPerformanceParam implements Cloneable{
    @ApiModelProperty(value = "演出活动ID [如果不存在，则新增演出项目]")
    String performanceId;
    @ApiModelProperty(value = "演出活动名称 [必传]")
    String performanceName;
    @ApiModelProperty(value = "批文号 [有的话必传]")
    String approval;
    @ApiModelProperty(value = "演出类型编码，参考附录演出类型 [必传]")
    Integer typeId;
    @ApiModelProperty(value = "演出封面图 [非必传]")
    String posterUrl;
    @ApiModelProperty(value = "演出描述 [非必传]")
    String performanceDesc;
    @ApiModelProperty(value = "主办方，多个用英文逗号分隔 [非必传]")
    String sponsor;
    @ApiModelProperty(value = " 演员，多个用英文逗号分隔 [非必传]")
    String performer;
    @ApiModelProperty(value = "演出场次ID List，传多个场次时可以批量获取场次编码 [必传]")
    List<TimesVo> sessionList;

    private static final STInsertPerformanceParam obj = new STInsertPerformanceParam();

    public static STInsertPerformanceParam getNew() {
        try {
            return (STInsertPerformanceParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STInsertPerformanceParam();
    }
}
