package com.liquidnet.service.sweet.dto.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

@ApiModel(value = "SweetAntigenicQuestionParam", description = "防疫答题记录入参")
@Data
public class SweetAntigenicQuestionParam implements Serializable {

    private static final long serialVersionUID = 9038992103808199663L;

    @ApiModelProperty(position = 10, required = true, value = "type 1MDSK防疫答题 2草莓防疫答题", example = "1")
    @NotNull(message = "type不能为空") @Min(value = 1, message = "type无效") @Max(value = 2, message = "type无效")
    private Integer type;

    @ApiModelProperty(position = 10, required = true, value = "openId", example = "openId")
    @NotBlank(message = "openId不能为空")
    private String openId;

    @ApiModelProperty(position = 10, required = true, value = "unionId", example = "unionId")
    @NotBlank(message = "unionId不能为空")
    private String unionId;

    @ApiModelProperty(position = 10, required = true, value = "姓名", example = "姓名")
    @NotBlank(message = "姓名不能为空")
    private String nickname;

    @ApiModelProperty(position = 10, required = true, value = "居住地址", example = "居住地址")
    @NotBlank(message = "居住地址不能为空")
    private String address;

    @ApiModelProperty(position = 10, required = true, value = "联系电话", example = "15811009011")
    @NotBlank(message = "联系电话不能为空")
    private String phone;

    @ApiModelProperty(position = 10, required = true, value = "紧急联系人电话", example = "15811009011")
//    @NotBlank(message = "紧急联系人电话不能为空")
    private String urgentPhone;

    @ApiModelProperty(position = 10, required = true, value = "keyword1", example = "1")
    @NotBlank(message = "keyword1不能为空")
    private String keyword1;

    @ApiModelProperty(position = 10, required = false, value = "keyword11", example = "补充信息")
    private String keyword11;

    @ApiModelProperty(position = 10, required = true, value = "keyword2", example = "1")
    @NotBlank(message = "keyword2不能为空")
    private String keyword2;

    @ApiModelProperty(position = 10, required = true, value = "keyword3", example = "1")
    @NotBlank(message = "keyword3不能为空")
    private String keyword3;

    @ApiModelProperty(position = 10, required = true, value = "keyword4", example = "1")
    @NotBlank(message = "keyword4不能为空")
    private String keyword4;

    @ApiModelProperty(position = 10, required = true, value = "keyword5", example = "1")
    @NotBlank(message = "keyword5不能为空")
    private String keyword5;

    @ApiModelProperty(position = 10, required = true, value = "keyword6", example = "1")
    @NotBlank(message = "keyword6不能为空")
    private String keyword6;

    @ApiModelProperty(position = 10, required = true, value = "keyword7", example = "1")
    @NotBlank(message = "keyword7不能为空")
    private String keyword7;

}
