package com.liquidnet.service.sweet.controller;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.entity.SweetManualNotifyMdsk;
import com.liquidnet.service.sweet.service.ISweetManualNotifyMdskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 电子宣传手册通知表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Api(tags = "电子手册通知_MDSK")
@RestController
@RequestMapping("/mdsk/sweet-manual-notify-mdsk")
public class SweetManualNotifyMdskController {

    @Autowired
    ISweetManualNotifyMdskService sweetManualNotifyMdskService;

    @GetMapping("list")
    @ApiOperation("通知列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "name", value = "通知标题 不查询从传递null", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
    })
    public ResponseDto<PageInfo<SweetManualNotifyMdsk>> getList(@RequestParam() Integer page,
                                                                @RequestParam() Integer size,
                                                                @RequestParam( required = false) String name,
                                                                @RequestParam() String manualId) {
        return sweetManualNotifyMdskService.getList(page, size, name, manualId);
    }

    @PostMapping("add")
    @ApiOperation("添加通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "标题", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "content", value = "内容", required = true),
    })
    public ResponseDto<Boolean> add(@RequestParam() String manualId,
                                    @RequestParam() String title,
                                    @RequestParam() String content) {
        return sweetManualNotifyMdskService.add(manualId, title, content);
    }

    @GetMapping("detail")
    @ApiOperation("通知详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualNotifyId", value = "通知id", required = true),
    })
    public ResponseDto<SweetManualNotifyMdsk> detail(@RequestParam() String manualNotifyId) {
        return sweetManualNotifyMdskService.details(manualNotifyId);
    }

    @PostMapping("change")
    @ApiOperation("修改通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualNotifyId", value = "通知id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "标题", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "content", value = "内容", required = true),
    })
    public ResponseDto<Boolean> change(@RequestParam() String manualId,
                                       @RequestParam() String manualNotifyId,
                                       @RequestParam() String title,
                                       @RequestParam() String content) {
        return sweetManualNotifyMdskService.change(manualId, manualNotifyId, title, content);
    }

    @DeleteMapping("delete")
    @ApiOperation("删除通知")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualNotifyId", value = "手册通知id", required = true),
    })
    public ResponseDto<Boolean> delete(@RequestParam() String manualNotifyId) {
        return sweetManualNotifyMdskService.delete(manualNotifyId);
    }

}
